% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEtest.R
\name{metaGE.test}
\alias{metaGE.test}
\title{Meta-analysis test for Genotype x Environment interactions: Contrast or Regression.}
\usage{
metaGE.test(
  Data,
  MatCorr,
  Incidence = NULL,
  Contrast = NULL,
  Covariate = NULL,
  EnvName = NULL,
  NA.omit = TRUE,
  DropZScores = FALSE
)
}
\arguments{
\item{Data}{A dataset containing the estimated marker effect and its associated pvalue of each marker (in rows) in each environment (in columns), as obtained from metaGE.collect.}

\item{MatCorr}{The inter-environment correlation matrix. It can be compute by the metaGE.cor function.}

\item{Incidence}{A matrix of incidence, as obtained from metaGE.incidence or a list of such matrix.}

\item{Contrast}{A matrix of contrast, or a list of such matrix.}

\item{Covariate}{A dataset containing the values of one or more covariates (in columns) in each environment (in rows).}

\item{EnvName}{The name of the column containing the names of the environment in the covariate dataset.}

\item{NA.omit}{A boolean specifying whether the markers with some NA values should be removed from the test procedure. (TRUE by default)}

\item{DropZScores}{A boolean specifying whether the Zscores should be dropped from the dataset or not. (FALSE by default)}
}
\value{
The dataset Data with supplementary columns containing the Pvalue of each test performed.
}
\description{
The function metaGE.test compute meta-analysis contrast or regression test.
}
\details{
If Incidence is provided, the function will perform all the corresponding tests of contrast. If Covariate is provided, the function will perform all the corresponding meta-regression tests.
The Contrast can be NULL, in this case the identity matrix is used.
}
\examples{
require(dplyr)

 # Import the data
data("metaData")
data("envDesc")

#' # Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

#### Contrast test
# Build the matrix of incidence
Incidence.Water <- metaGE.incidence(VarName = "Water",Covariate = envDesc,
                                    EnvName = "ShortName", Data = metaData)

# Perform the contrast test
ContrastDF <- metaGE.test(metaData, matCorr,Incidence = Incidence.Water, Contrast = NULL)
head(ContrastDF \%>\% select(CHR, POS, MARKER, PVALUE.Contrast1))

#### Regression test
RegressionDF <- metaGE.test(metaData,matCorr, Covariate = envDesc[,c(1,5)],EnvName = "ShortName" )
head(RegressionDF \%>\% select(CHR, POS, MARKER, PVALUE.Tnight.mean))
}
