% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_aggregate_df.R
\name{aggregate_df}
\alias{aggregate_df}
\title{Aggregate a dataframe containing dependent effect sizes}
\usage{
aggregate_df(
  x,
  dependence = "outcomes",
  cor_unit = 0.8,
  agg_fact,
  es = "es",
  se = "se",
  col_mean = NA,
  col_weighted_mean = NA,
  weights = NA,
  col_sum = NA,
  col_min = NA,
  col_max = NA,
  col_fact = NA,
  na.rm = TRUE
)
}
\arguments{
\item{x}{a dataframe that should be aggregated (must contain effect size values and standard errors).}

\item{dependence}{The type of dependence in your dataframe (can be either "outcomes" or "subgroups"). See details.}

\item{cor_unit}{The correlation between effect sizes coming from the same clustering unit (only used when \code{dependence = "times"} or \code{dependence = "outcomes"}).}

\item{agg_fact}{A character string identifying the column name that contains the clustering units (all rows with the same \code{agg_fact} value will be aggregated together).}

\item{es}{A character string identifying the column name containing the effect size values. Default is "es".}

\item{se}{A character string identifying the column name containing the standard errors of the effect size. Default is "se".}

\item{col_mean}{a vector of character strings identifying the column names for which the dependent values are summarized by taking their mean.}

\item{col_weighted_mean}{a vector of character strings identifying the column names for which the dependent values are summarized by taking their weighted mean.}

\item{weights}{The weights that will be used to estimated the weighted means.}

\item{col_sum}{a vector of character strings identifying the column names for which the dependent values are summarized by taking their sum.}

\item{col_min}{a vector of character strings identifying the column names for which the dependent values are summarized by taking their minimum.}

\item{col_max}{a vector of character strings identifying the column names for which the dependent values are summarized by taking their maximum.}

\item{col_fact}{a vector of character strings identifying the column names that are factors (different values will be separated by a "/" character).}

\item{na.rm}{a logical vector indicating whether missing values should be ignored in the calculations for the \code{col_mean}, \code{col_weighted_mean}, \code{col_sum}, \code{col_min} and \code{col_max} arguments.}
}
\value{
The object returned by the \code{aggregate_df} contains, is a dataframe containing at the very least,
the aggregating factor, and the aggregated effect size values and standard errors. All columns indicated in the \code{col_*} arguments
will also be included in this dataframe.
\tabular{ll}{
\code{row_id} \tab the row number in the original dataset.\cr
\tab \cr
\code{es} \tab the aggregated effect size value.\cr
\tab \cr
\code{se} \tab the standard error of the aggregated effect size.\cr
\tab \cr
\code{...} \tab any columns indicated in the \code{col_*} arguments.\cr
\tab \cr
}
}
\description{
Aggregate a dataframe containing dependent effect sizes
}
\details{
\enumerate{
\item In the \code{dependence} argument, you should indicate "outcomes" if the dependence within the same clustering unit (e.g., study) is due to the presence of multiple effect sizes produced from the same participants at the same time-point (e.g., multiple outcome measures)
\item In the \code{dependence} argument, you should indicate "times" if the dependence within the same clustering unit (e.g., study) is due to the presence of multiple effect sizes produced from the same participants at the different time-points (e.g., an RCT with several follow-up waves).
\item In the \code{dependence} argument, you should indicate "subgroups" if the dependence within the same clustering unit (e.g., study) is due to the presence of multiple effect sizes produced by independent subgroups (e.g., one effect size for boys, and one for girls).
}

If you are working with ratio measures, make sure that the information on
the effect size estimates (i.e., the column passed to the es argument of the function)
is presented on the log scale.
}
\examples{
res <- summary(convert_df(df.haza, measure = "d"))
aggregate_df(res, dependence = "outcomes", cor_unit = 0.8,
             agg_fact = "study_id", es = "es_crude", se = "se_crude",
             col_fact = c("outcome", "type_publication"))

}
