% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_means.R
\name{es_from_ancova_means_sd}
\alias{es_from_ancova_means_sd}
\title{Convert means and standard deviations of two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_means_sd(
  n_exp,
  n_nexp,
  ancova_mean_exp,
  ancova_mean_nexp,
  ancova_mean_sd_exp,
  ancova_mean_sd_nexp,
  cov_outcome_r,
  n_cov_ancova,
  smd_to_cor = "viechtbauer",
  reverse_ancova_means
)
}
\arguments{
\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_exp}{adjusted mean of participants in the experimental/exposed group.}

\item{ancova_mean_nexp}{adjusted mean of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_sd_exp}{adjusted standard deviation of participants in the experimental/exposed group.}

\item{ancova_mean_sd_nexp}{adjusted standard deviation of participants in the non-experimental/non-exposed group.}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 19. Adjusted: Means and dispersion'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert means and standard deviations of two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function first computes an "adjusted" mean difference (MD),
Cohen's d (D) and Hedges' g (G) from the adjusted means and standard deviations.
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

This function start by estimating the non-adjusted standard deviation of the two groups (formula 12.24 in Cooper);
\deqn{mean\_sd\_exp = \frac{ancova\_mean\_sd\_exp}{\sqrt{1 - cov\_outcome\_r^2}}}
\deqn{mean\_sd\_nexp = \frac{ancova\_mean\_sd\_nexp}{\sqrt{1 - cov\_outcome\_r^2}}}

\strong{To obtain the mean difference}, the following formulas are used (authors calculations):
\deqn{md = ancova\_mean\_exp - ancova\_mean\_nexp}
\deqn{md\_se = \sqrt{\frac{mean\_sd\_exp^2}{n\_exp} + \frac{mean\_sd\_nexp^2}{n\_nexp}}}
\deqn{md\_ci\_lo = md - md\_se * qt(.975, n\_exp+n\_nexp-2-n\_cov\_ancova)}
\deqn{md\_ci\_up = md + md\_se * qt(.975, n\_exp+n\_nexp-2-n\_cov\_ancova)}

\strong{To obtain the Cohen's d}, the following formulas are used (table 12.3 in Cooper):
\deqn{mean\_sd\_pooled = \sqrt{\frac{(n\_exp - 1) * ancova\_mean\_exp^2 + (n\_nexp - 1) * ancova\_mean\_nexp^2}{n\_exp+n\_nexp-2}}}
\deqn{cohen\_d =  \frac{ancova\_mean\_exp - ancova\_mean\_nexp}{mean\_sd\_pooled}}
\deqn{cohen\_d\_se = \frac{(n\_exp+n\_nexp)*(1-cov\_outcome\_r^2)}{n\_exp*n\_nexp} + \frac{cohen\_d^2}{2(n\_exp+n\_nexp)}}
\deqn{cohen\_d\_ci\_lo = cohen\_d - cohen\_d\_se * qt(.975, n\_exp + n\_nexp - 2 - n\_cov\_ancova)}
\deqn{cohen\_d\_ci\_up = cohen\_d + cohen\_d\_se * qt(.975, n\_exp + n\_nexp - 2 - n\_cov\_ancova)}

\strong{To estimate other effect size measures},
Calculations of the \code{\link{es_from_cohen_d_adj}()} are applied.
}
\examples{
es_from_ancova_means_sd(
  n_exp = 55, n_nexp = 55,
  ancova_mean_exp = 2.3, ancova_mean_sd_exp = 1.2,
  ancova_mean_nexp = 1.9, ancova_mean_sd_nexp = 0.9,
  cov_outcome_r = 0.2, n_cov_ancova = 3
)

}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
