% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.rob.R
\name{barplot.rob}
\alias{barplot.rob}
\title{Produce weighted bar plot of risk of bias assessment}
\usage{
\method{barplot}{rob}(
  height,
  overall = FALSE,
  weighted = TRUE,
  colour = "cochrane",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{height}{An object of class \code{rob}.}

\item{overall}{A logical indicating whether to include a bar for
overall risk of bias in the figure.}

\item{weighted}{A logical indicating whether weights should be used
in the bar plot.}

\item{colour}{Specify colour scheme for the bar plot; see
\code{\link[robvis]{rob_summary}}.}

\item{quiet}{A logical to suppress the display of the bar plot.}

\item{\dots}{Additional arguments (ignored)}
}
\description{
Produce weighted bar plot of risk of bias assessment
}
\details{
This is a wrapper function for \code{\link[robvis]{rob_summary}} of
R package \bold{robvis} to produce a weighted bar plot of risk of
bias assessment.
}
\examples{
# Use RevMan 5 settings
oldset <- settings.meta("RevMan5")

data(caffeine)

m1 <- metabin(h.caf, n.caf, h.decaf, n.decaf, sm = "OR",
  data = caffeine, studlab = paste(study, year))

# Add risk of bias assessment to meta-analysis
m2 <- rob(D1, D2, D3, D4, D5, overall = rob, data = m1, tool = "rob2")

# Print risk of bias assessment
rob(m2)

\dontrun{
# Weighted bar plot (R package 'robvis' must be available)
if (requireNamespace("robvis", quietly = TRUE))
 barplot(rob(m2))
}

# Use previous settings
settings.meta(oldset)

}
\seealso{
\code{\link{rob}}, \code{\link{traffic_light}},
  \code{\link[robvis]{rob_summary}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
