% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamean.R
\name{metamean}
\alias{metamean}
\title{Meta-analysis of single means}
\usage{
metamean(
  n,
  mean,
  sd,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  median,
  q1,
  q3,
  min,
  max,
  method.mean = "Luo",
  method.sd = "Shi",
  approx.mean,
  approx.sd,
  sm = gs("smmean"),
  method.ci = gs("method.ci.cont"),
  level = gs("level"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = common | random,
  prediction = gs("prediction") | !missing(method.predict),
  method.tau = gs("method.tau"),
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  level.ma = gs("level.ma"),
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  level.predict = gs("level.predict"),
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  null.effect = NA,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  byvar,
  adhoc.hakn,
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{n}{Number of observations.}

\item{mean}{Estimated mean.}

\item{sd}{Standard deviation.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{median}{Median (used to estimate the mean and standard
deviation).}

\item{q1}{First quartile (used to estimate the mean and standard
deviation).}

\item{q3}{Third quartile (used to estimate the mean and standard
deviation).}

\item{min}{Minimum (used to estimate the mean and standard
deviation).}

\item{max}{Maximum (used to estimate the mean and standard
deviation).}

\item{method.mean}{A character string indicating which method to
use to approximate the mean from the median and other statistics
(see Details).}

\item{method.sd}{A character string indicating which method to use
to approximate the standard deviation from sample size, median,
interquartile range and range (see Details).}

\item{approx.mean}{Approximation method to estimate means (see
Details).}

\item{approx.sd}{Approximation method to estimate standard
deviations (see Details).}

\item{sm}{A character string indicating which summary measure
(\code{"MRAW"} or \code{"MLN"}) is to be used for pooling of
studies.}

\item{method.ci}{A character string indicating which method is used
to calculate confidence intervals for individual studies, see
Details.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots for \code{sm = "MLN"}. If
TRUE (default), results will be presented as means; otherwise
logarithm of means will be shown.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{adhoc.hakn}{Deprecated argument (replaced by 'adhoc.hakn.ci').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard deviations).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}}.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{c("metamean", "meta")} with corresponding
generic functions (see \code{\link{meta-object}}).
}
\description{
Calculation of an overall mean from studies reporting a single mean
using the inverse variance method for pooling; inverse variance
weighting is used for pooling.
}
\details{
Common effect and random effects meta-analysis of single means to
calculate an overall mean; inverse variance weighting is used for
pooling. Note, you should use R function \code{\link{metacont}} to
compare means of pairwise comparisons instead of using
\code{metamean} for each treatment arm separately which will break
randomisation in randomised controlled trials.

A three-level random effects meta-analysis model (Van den Noortgate
et al., 2013) is utilized if argument \code{cluster} is used and at
least one cluster provides more than one estimate. Internally,
\code{\link[metafor]{rma.mv}} is called to conduct the analysis and
\code{\link[metafor]{weights.rma.mv}} with argument \code{type =
"rowsum"} is used to calculate random effects weights.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

The following transformations of means are implemented to
calculate an overall mean:
\itemize{
\item Raw, i.e. untransformed, means (\code{sm = "MRAW"}, default)
\item Log transformed means (\code{sm = "MLN"})
}

Calculations are conducted on the log scale if \code{sm =
"ROM"}. Accordingly, list elements \code{TE}, \code{TE.common}, and
\code{TE.random} contain the logarithm of means. In printouts and
plots these values are back transformed if argument
\code{backtransf = TRUE} (default).

\subsection{Approximate means from sample sizes, medians and other statistics}{

Missing means can be derived from
\enumerate{
\item sample size, median, interquartile range and range (arguments
  \code{n}, \code{median}, \code{q1}, \code{q3}, \code{min}, and
  \code{max}),
\item sample size, median and interquartile range (arguments
  \code{n}, \code{median}, \code{q1}, and \code{q3}), or
\item sample size, median and range (arguments \code{n},
  \code{median}, \code{min}, and \code{max}).
}

By default, methods described in Luo et al. (2018) are utilized
(argument \code{method.mean = "Luo"}):
\itemize{
\item equation (15) if sample size, median, interquartile range and 
  range are available,
\item equation (11) if sample size, median and interquartile range
  are available,
\item equation (7) if sample size, median and range are available.
}

Instead the methods described in Wan et al. (2014) are used if
argument \code{method.mean = "Wan"}:
\itemize{
\item equation (10) if sample size, median, interquartile range and 
  range are available,
\item equation (14) if sample size, median and interquartile range
  are available,
\item equation (2) if sample size, median and range are available.
}

The following methods are also available to estimate means from
quantiles or ranges if R package \bold{estmeansd} is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing means are replaced successively using
interquartile ranges and ranges (if available), interquartile
ranges (if available) and finally ranges. Argument
\code{approx.mean} can be used to overwrite this behaviour for each
individual study and treatment arm:
\itemize{
\item use means directly (entry \code{""} in argument
  \code{approx.mean});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Approximate standard deviations from sample sizes, medians and other statistics}{

Missing standard deviations can be derived from
\enumerate{
\item sample size, median, interquartile range and range (arguments
  \code{n}, \code{median}, \code{q1}, \code{q3}, \code{min}, and
  \code{max}),
\item sample size, median and interquartile range (arguments
  \code{n}, \code{median}, \code{q1} and \code{q3}), or
\item sample size, median and range (arguments \code{n},
  \code{median}, \code{min} and \code{max}).
}

Wan et al. (2014) describe methods to estimate the standard
deviation from the sample size, median and additional
statistics. Shi et al. (2020) provide an improved estimate of the
standard deviation if the interquartile range and range are
available in addition to the sample size and median. Accordingly,
equation (11) in Shi et al. (2020) is the default (argument
\code{method.sd = "Shi"}), if the median, interquartile range and
range are provided. The method by Wan et al. (2014) is used if
argument \code{method.sd = "Wan"} and, depending on the sample
size, either equation (12) or (13) is used. If only the
interquartile range or range is available, equations (15) / (16)
and (7) / (9) in Wan et al. (2014) are used, respectively.

The following methods are also available to estimate standard
deviations from quantiles or ranges if R package \bold{estmeansd}
is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing standard deviations are replaced successively
using these method, i.e., interquartile ranges and ranges are used
before interquartile ranges before ranges. Argument
\code{approx.sd} can be used to overwrite this default for each
individual study and treatment arms:
\itemize{
\item sample size, median, interquartile range and range
  (\code{"iqr.range"});
\item sample size, median and interquartile range (\code{"iqr"});
\item sample size, median and range (\code{"range"}).
}
}

\subsection{Confidence intervals for individual studies}{

For untransformed means (argument \code{sm = "MRAW"}), the
confidence interval for individual studies can be based on the
\itemize{
\item standard normal distribution (\code{method.ci = "z"}, default), or
\item t-distribution (\code{method.ci = "t"}).
}
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments
\code{common} and \code{random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{common} and \code{random}. E.g. functions
\code{\link{print.meta}} and \code{\link{forest.meta}} will not
print results for the random effects model if \code{random =
FALSE}.

A prediction interval will only be shown if \code{prediction =
TRUE}.
}
}
\note{
The function \code{\link{metagen}} is called internally to
calculate individual and overall treatment estimates and standard
errors.
}
\examples{
m1 <- metamean(rep(100, 3), 1:3, rep(1, 3))
m1

m2 <- update(m1, sm = "MLN")
m2

# With test for overall mean equal to 2
#
update(m1, null.effect = 2)
update(m2, null.effect = 2)

# Print results without back-transformation
#
update(m1, backtransf = FALSE)
update(m2, backtransf = FALSE)
update(m1, null.effect = 2, backtransf = FALSE)
update(m2, null.effect = 2, backtransf = FALSE)

}
\references{
Cai S, Zhou J, Pan J (2021):
Estimating the sample mean and standard deviation from order
statistics and sample size in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{30}, 2701--2719

Luo D, Wan X, Liu J, Tong T (2018):
Optimally estimating the sample mean from the sample size, median,
mid-range, and/or mid-quartile range.
\emph{Statistical Methods in Medical Research},
\bold{27}, 1785--805

McGrath S, Zhao X, Steele R, et al. and the DEPRESsion Screening
Data (DEPRESSD) Collaboration (2020):
Estimating the sample mean and standard deviation from commonly
reported quantiles in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{29}, 2520--2537

Shi J, Luo D, Weng H, Zeng X-T, Lin L, Chu H, et al. (2020):
Optimally estimating the sample standard deviation from the
five-number summary.
\emph{Research Synthesis Methods}.

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca
J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94

Wan X, Wang W, Liu J, Tong T (2014):
Estimating the sample mean and standard deviation from the sample
size, median, range and/or interquartile range.
\emph{BMC Medical Research Methodology},
\bold{14}, 135
}
\seealso{
\code{\link{meta-package}}, \code{\link{update.meta}},
  \code{\link{metamean}}, \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
