\name{forest.meta}

\alias{forest.meta}

\title{Forest plot plot function for objects of class meta}

\description{
  Draws a forest plot in the active graphics window (using grid
  graphics system).
}

\usage{
\method{forest}{meta}(x, sortvar, studlab=TRUE,
       comb.fixed=x$comb.fixed, comb.random=x$comb.random,
       overall=TRUE,
       text.fixed=if (x$level!=x$level.comb) paste("Fixed effect model (",
                    round(x$level.comb*100), "\%-CI)", sep="") else "Fixed effect model",
       text.random=if (x$level!=x$level.comb) paste("Random effects model (",
                    round(x$level.comb*100), "\%-CI)", sep="") else "Random effects model",
       lty.fixed=2, lty.random=3,
       prediction=x$prediction,
       text.predict=if (!(length(x$level.predict)==0) && x$level!=x$level.predict)
                     paste("Prediction interval (", round(x$level.predict*100), "\%)",
                     sep="") else "Prediction interval",
       bylab=x$bylab, print.byvar=x$print.byvar,
       text.fixed.w=text.fixed, text.random.w=text.random,
       bysort=FALSE,
       pooled.totals=comb.fixed|comb.random, pooled.events=FALSE,
       xlab="", xlab.pos=ref,
       smlab=NULL, smlab.pos=ref, xlim="symmetric",
       allstudies=TRUE,
       weight,
       pscale=1,
       ref=ifelse(x$sm \%in\% c("RR", "OR", "HR", "IRR"), 1, 0),
       leftcols=NULL, rightcols=NULL,
       leftlabs=NULL, rightlabs=NULL,
       lab.e=x$label.e, lab.c=x$label.c,
       lab.e.attach.to.col=NULL, lab.c.attach.to.col=NULL,
       label.right=x$label.right, label.left=x$label.left,
       lab.NA=".",
       lwd=1,
       at=NULL, label=TRUE,
       col.i="black", col.i.inside.square="white",
       col.square="gray", col.square.lines=col.square,
       col.diamond="gray",
       col.diamond.fixed=col.diamond, col.diamond.random=col.diamond,
       col.diamond.lines="black",
       col.diamond.fixed.lines=col.diamond.lines,
       col.diamond.random.lines=col.diamond.lines,
       col.predict="red", col.predict.lines="black",
       col.by="darkgray",
       print.I2=comb.fixed|comb.random, print.tau2=comb.fixed|comb.random,
       print.Q=FALSE, print.pval.Q=comb.fixed|comb.random,
       hetstat=print.I2|print.tau2|print.Q|print.pval.Q,
       overall.hetstat=overall&hetstat,
       hetlab="Heterogeneity: ",
       fontsize=12,
       fs.heading=fontsize,
       fs.fixed=fontsize, fs.random=fs.fixed, fs.predict=fs.fixed, fs.study=fontsize,
       fs.fixed.labels=fs.fixed, fs.random.labels=fs.random, fs.predict.labels=fs.predict,
       fs.study.labels=fs.study, fs.hetstat=fontsize-2,
       fs.axis=fontsize,
       fs.smlab=fontsize, fs.xlab=fontsize, fs.lr=fontsize,
       ff.heading="bold",
       ff.fixed="bold", ff.random=ff.fixed, ff.predict=ff.fixed, ff.study="plain",
       ff.fixed.labels=ff.fixed, ff.random.labels=ff.random, ff.predict.labels=ff.predict,
       ff.study.labels=ff.study, ff.hetstat="bold.italic",
       ff.axis="plain",
       ff.smlab="bold", ff.xlab="plain", ff.lr="plain",
       ##
       squaresize=0.8,
       ##
       plotwidth=unit(6, "cm"),
       colgap=unit(2, "mm"),
       colgap.left=colgap, colgap.right=colgap,
       colgap.forest=colgap,
       colgap.forest.left=colgap.forest, colgap.forest.right=colgap.forest,
       ##
       just="center",
       just.studlab="left",
       ##
       addspace=TRUE,
       ##
       new=TRUE,
       ##
       digits=2, ...)
}

\arguments{
  \item{x}{An object of class \code{meta}.}
  \item{sortvar}{An optional vector used to sort the individual studies
    (must be of same length as \code{x$TE}).}
  \item{studlab}{A logical indicating whether study labels should be
    printed in the graph. A vector with study labels can also be
    provided (must be of same length as \code{x$TE} then).}
  \item{level}{The level used to calculate confidence intervals for
    individual studies.}
  \item{level.comb}{The level used to calculate confidence intervals for
    pooled estimates.}
  \item{comb.fixed}{A logical indicating whether fixed effect estimate
  should be plotted.}
  \item{comb.random}{A logical indicating whether random effects estimate
  should be plotted.}
  \item{overall}{A logical indicating whether overall summaries should
    be plotted. This argument is useful in combination with the
    argument \code{byvar} if summaries should only be plotted on group
    level.}
  \item{text.fixed}{A character string used in the plot to label the
    pooled fixed effect estimate.}
  \item{text.random}{A character string used in the plot to label the
    pooled random effects estimate.}
  \item{lty.fixed}{Line type (pooled fixed effect estimate).}
  \item{lty.random}{Line type (pooled random effects estimate).}
  \item{prediction}{A logical indicating whether a prediction interval
    should be printed.}
  \item{level.predict}{The level used to calculate prediction interval
    for a new study.}
  \item{text.predict}{A character string used in the plot to label the
    prediction interval.}
  \item{bylab}{A character string with a label for the grouping variable.}
  \item{print.byvar}{A logical indicating whether the name of the grouping
    variable should be printed in front of the group labels.}
  \item{text.fixed.w}{A character string to label the pooled fixed
    effect estimate within subgroups, or a character vector of same
    length as number of subgroups with corresponging labels.}
  \item{text.random.w}{A character string to label the pooled random
    effect estimate within subgroups, or a character vector of same
    length as number of subgroups with corresponging labels.}
  \item{bysort}{A logical indicating whether groups should be ordered
    alphabetically.}
  \item{pooled.totals}{A logical indicating whether total number of
    observations should be given in the figure.}
  \item{pooled.events}{A logical indicating whether total number of
    events should be given in the figure.}
  \item{xlab}{A label for the x axis.}
  \item{xlab.pos}{A numeric specifying the center of the label
    on the x axis.}
  \item{smlab}{A label for the summary measurex (printed at top of figure).}
  \item{smlab.pos}{A numeric specifying the center of the label
    for the summary measure.}
  \item{xlim}{The x limits (min,max) of the plot, or the character "s"
    to produce symmetric forest plots.}
  \item{allstudies}{A logical indicating whether studies with inestimable
    treatment effects should be plotted.}
  \item{weight}{A character string indicating which type of plotting
    symbols is to be used for individual treatment estimates. One of
    missing (see Details), \code{"same"}, \code{"fixed"}, or
    \code{"random"}, can be abbreviated. Plot symbols have the same size
    for all studies or represent study weights from fixed effect or
    random effects model.}
  \item{pscale}{A numeric giving scaling factor for probabilities for
    objects of class \code{metaprop}.}
  \item{ref}{A numerical giving the reference value to be plotted as a
    line in the forest plot. No reference line is plotted if argument
    \code{ref} is equal to \code{NA}.}
  \item{leftcols}{A character vector specifying (additional) columns
  to be plotted on the left side of the forest plot or a logical value
  (see Details).}
  \item{rightcols}{A character vector specifying (additional) columns
  to be plotted on the right side of the forest plot or a logical
  value (see Details).}
  \item{leftlabs}{A character vector specifying labels for (additional)
  columns on left side of the forest plot (see Details).}
  \item{rightlabs}{A character vector specifying labels for (additional)
  columns on right side of the forest plot (see Details).}
  \item{lab.e}{Label to be used for experimental group in table
    heading.}
  \item{lab.c}{Label to be used for control group in table
    heading.}
  \item{lab.e.attach.to.col}{A character specifying the column name where
    label \code{lab.e} should be attached to in table heading.}
  \item{lab.c.attach.to.col}{A character specifying the column name where
    label \code{lab.c} should be attached to in table heading.}
  \item{label.left}{Graph label on left side of forest plot.}
  \item{label.right}{Graph label on right side of forest plot.}
  \item{lab.NA}{A character string to label missing values.}
  \item{lwd}{The line width, see \code{\link{par}}.}
  \item{at}{The points at which tick-marks are to be drawn, see
  \code{grid.xaxis}.}
  \item{label}{A logical value indicating whether to draw the
    labels on the tick marks, or an expression or character vector which
    specify the labels to use. See \code{\link{grid.xaxis}}.}
  \item{col.i}{The colour for individual study results and confidence limits.}
  \item{col.i.inside.square}{The colour for individual study results and
    confidence limits if confidence limits are completely within squares.}
  \item{col.square}{The colour for squares reflecting study's weight in
    the meta-analysis.}
  \item{col.square.lines}{The colour for the outer lines of squares
    reflecting study's weight in the meta-analysis.}
  \item{col.diamond}{The colour of diamonds representing the results for
    fixed effect and random effects models.}
  \item{col.diamond.fixed}{The colour of diamonds for fixed effect estimates.}
  \item{col.diamond.random}{The colour of diamonds for random effects estimates.}
  \item{col.diamond.lines}{The colour of the outer lines of diamonds
    representing the results for fixed effect and random effects models.}
  \item{col.diamond.fixed.lines}{The colour of the outer lines of diamond
    for fixed effect estimate.}
  \item{col.diamond.random.lines}{The colour of the outer lines of diamond
    for random effects estimate.}
  \item{col.predict}{Background colour of prediction interval.}
  \item{col.predict.lines}{Colour of outer lines of prediction interval.}
  \item{col.by}{The colour to print information on subgroups.}
  \item{print.I2}{A logical value indicating whether to print the value
    of the I-squared statistic.}
  \item{print.tau2}{A logical value indicating whether to print the value
    of the between-study variance tau-squared.}
  \item{print.Q}{A logical value indicating whether to print the value
    of the heterogeneity statistic Q.}
  \item{print.pval.Q}{A logical value indicating whether to print the
    p-value of the heterogeneity statistic Q.}
  \item{hetstat}{A logical value indicating whether to print results for
    heterogeneity measures at all.}
  \item{overall.hetstat}{A logical value indicating whether to print
    results for heterogeneity measures for overall treatment
    comparisons. This argument is useful in combination with subgroup
    analyses (list object \code{byvar}) if heterogeneity statistics
    should only be printed on group level.}
  \item{hetlab}{Label printed in front of results for heterogeneity measures.}
  \item{fontsize}{The size of text (in points), see \code{\link{gpar}}.}
  \item{fs.heading}{The size of text for column headings, see \code{\link{gpar}}.}
  \item{fs.fixed}{The size of text for results of fixed effect model, see \code{\link{gpar}}.}
  \item{fs.random}{The size of text for results of random effects model, see \code{\link{gpar}}.}
  \item{fs.predict}{The size of text for results of prediction interval, see \code{\link{gpar}}.}
  \item{fs.study}{The size of text for results of individual studies, see \code{\link{gpar}}.}
  \item{fs.fixed.labels}{The size of text for label of fixed effect model, see \code{\link{gpar}}.}
  \item{fs.random.labels}{The size of text for label of random effects model, see \code{\link{gpar}}.}
  \item{fs.predict.labels}{The size of text for label of prediction interval, see \code{\link{gpar}}.}
  \item{fs.study.labels}{The size of text for labels of individual studies, see \code{\link{gpar}}.}
  \item{fs.hetstat}{The size of text for heterogeneity measures, see \code{\link{gpar}}.}
  \item{fs.axis}{The size of text on x-axis, see \code{\link{gpar}}.}
  \item{fs.smlab}{The size of text of label for summary measure, see \code{\link{gpar}}.}
  \item{fs.xlab}{The size of text of label on x-axis, see \code{\link{gpar}}.}
  \item{fs.lr}{The size of text of label on left and right side of forest plot, see \code{\link{gpar}}.}
  \item{ff.heading}{The fontface for column headings, see \code{\link{gpar}}.}
  \item{ff.fixed}{The fontface of text for results of fixed effect model, see \code{\link{gpar}}.}
  \item{ff.random}{The fontface of text for results of random effects model, see \code{\link{gpar}}.}
  \item{ff.predict}{The fontface of text for results of prediction interval, see \code{\link{gpar}}.}
  \item{ff.study}{The fontface of text for results of individual studies, see \code{\link{gpar}}.}
  \item{ff.fixed.labels}{The fontface of text for label of fixed effect model, see \code{\link{gpar}}.}
  \item{ff.random.labels}{The fontface of text for label of random effects model, see \code{\link{gpar}}.}
  \item{ff.predict.labels}{The fontface of text for label of prediction interval, see \code{\link{gpar}}.}
  \item{ff.study.labels}{The fontface of text for labels of individual studies, see \code{\link{gpar}}.}
  \item{ff.hetstat}{The fontface of text for heterogeneity measures, see \code{\link{gpar}}.}
  \item{ff.axis}{The fontface of text on x-axis, see \code{\link{gpar}}.}
  \item{ff.smlab}{The fontface of text of label for summary measure, see \code{\link{gpar}}.}
  \item{ff.xlab}{The fontface of text of label on x-axis, see \code{\link{gpar}}.}
  \item{ff.lr}{The fontface of text of label on left and right side of forest plot, see \code{\link{gpar}}.}
  \item{squaresize}{A numeric used to increase or decrease the size of
    squares in the forest plot.}
  \item{plotwidth}{A unit object specifying width of the forest plot.}
  \item{colgap}{A unit object specifying gap between columns printed on
    left and right side of forest plot.}
  \item{colgap.left}{A unit object specifying gap between columns printed on
    left side of forest plot.}
  \item{colgap.right}{A unit object specifying gap between columns printed on
    right side of forest plot.}
  \item{colgap.forest}{A unit object specifying gap between column
    adjacent to forest plot and the forest plot.}
  \item{colgap.forest.left}{A unit object specifying gap between column
    on the left side of forest plot and the forest plot.}
  \item{colgap.forest.right}{A unit object specifying gap between column
    on the right side of forest plot and the forest plot.}
  \item{just}{Justification of text for additional columns (possible
    values: "left", "right", "center").}
  \item{just.studlab}{Justification of text for study labels (possible
    values: "left", "right", "center").}
  \item{addspace}{A logical value indicating whether additional space
    (i.e. a blank row) is printed above and below study results.}
  \item{new}{A logical value indicating whether a new figure should
    be printed in an existing graphics window.}
  \item{digits}{Minimal number of significant digits, see
    \code{print.default}.}
 \item{\dots}{Additional graphical arguments (ignored at the moment).}
}

\details{
  A forest plot, also called confidence interval plot, is drawn in the
  active graphics window. Subgroup analyses are conducted and
  displayed in the plot if \code{byvar} is not missing.
  
  Note, in R package meta, version 3.0-0 the following arguments have
  been removed from R function forest.meta: byvar, level, level.comb,
  level.predict. This functionality is now provided by R function
  \code{\link{update.meta}} (or directly in R functions
  \code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}, \code{\link{metacor}}, and
  \code{\link{metaprop}}).
  
  The \code{forest} function is based on the grid graphics
  system. In order to print the forest plot, (i) resize the graphics
  window, (ii) either use \code{\link{dev.copy2eps}} or
  \code{\link{dev.copy2pdf}}.
  
  Information from object \code{x} is utilised if argument \code{weight}
  is missing. Weights from the fixed effect model are used
  (\code{weight="fixed"}) if argument \code{x$comb.fixed} is
  \code{TRUE}; weights from the random effects model are used
  (\code{weight="random"}) if argument \code{x$comb.random}
  is \code{TRUE} and \code{x$comb.fixed} is \code{FALSE}.

  The arguments \code{leftcols} and \code{rightcols} can be used to
  specify columns which are plotted on the left and right side of the
  forest plot, respectively. If argument \code{rightcols} is
  \code{FALSE}, no columns will be plotted on the right side. By
  default, i.e. if arguments \code{leftcols} and \code{rightcols} are
  \code{NULL}, the following default columns will be plotted.

  Argument \code{rightcols}: \code{rightcols=c("effect", "ci")}, i.e.,
  estimated treatment effect and its \code{level}-confidence
  interval. In addition, weights of the fixed (\code{"w.fixed"}) and/or random effects
  model (\code{"w.random"}) will be given, if \code{comb.fixed=TRUE}
  and/or \code{comb.random=TRUE}. For an object
  of class \code{metacum} or \code{metainf} only the estimated treatment
  effect with \code{level}-confidence interval are plotted.
  
  Argument \code{leftcols}:
  (i) \code{leftcols=c("studlab", "event.e", "n.e", "event.c", "n.c")}
  for an object of class \code{metabin},
  (ii) \code{leftcols=c("studlab", "n.e", "mean.e", "sd.e", "n.c",
    "mean.c", "sd.c")} for an object of class \code{metacont},
  (iii) \code{leftcols=c("studlab", "TE", "seTE")}
  for an object of class \code{metagen},
  (iv) \code{leftcols=c("studlab", "event", "n")}
  for an object of class \code{metaprop},
  (v) \code{leftcols=c("studlab", "n")}
  for an object of class \code{metacor},
  (vi) \code{leftcols=c("studlab")}
  for an object of class \code{metacum} or \code{metainf}.

  The arguments \code{leftlabs} and \code{rightlabs} can be used to
  specify column headings which are plotted on left and right side of
  the forest plot, respectively. For certain columns predefined labels
  exist. If the arguments \code{leftlabs} and \code{rightlabs} are
  \code{NULL}, the following default labels will be used: for columns
  \code{c("studlab", "TE", "seTE", "n.e", "n.c", "event.e", "event.c",
  "mean.e", "mean.c", "sd.e", "sd.c", "effect", "ci", "w.fixed",
  "w.random")} the labels \code{c("Study", "TE", "seTE", "Total",
  "Total", "Events", "Events", "Mean", "Mean", "SD", "SD",
  summary measure, level for confidence interval, "W(fixed)",
  "W(random)")}. For additional columns the column name
  will be used as label. It is possible to only provide labels for new
  columns (see Examples). Otherwise the length of \code{leftlabs} and
  \code{rightlabs} must be the same as the number of printed
  columns. The value \code{NA} can be used to specify columns using the
  default labels (see Example).

  If arguments \code{lab.e} and \code{lab.c} are \code{NULL},
  "Experimental" and "Control" are used as labels for experimental and
  control group, respectively.
  
  The arguments \code{pscale} can be used to rescale proportions
  for objects of class \code{metaprop}, e.g. \code{pscale=100} means
  that proportions are expressed per 100 observations. This is useful in
  situations with (very) low proportions. For \code{pscale=100}, column
  heading and x-axis label are changed to "Prop (in \%)" and
  "Proportion (in \%)", respectively.

  A prediction interval for treatment effect of a new study (Higgins
  et al., 2009) is given in the forest plot if arguments
  \code{prediction} and \code{comb.random} are \code{TRUE}. For
  graphical presentation of prediction intervals the approach by
  Guddat et al. (2012) is used.
}

\references{
  Guddat C, Grouven U, Bender R, Skipka G 2012), A note on the
  graphical presentation of prediction intervals in random-effects
  meta-analyses. \emph{Systematic Reviews}, \bold{1}, 34.

  Higgins JPT, Thompson SG, Spiegelhalter DJ (2009),
  A re-evaluation of random-effects meta-analysis.
  \emph{Journal of the Royal Statistical Society: Series A},
  \bold{172}, 137-159.
}

\author{Guido Schwarzer \email{sc@imbi.uni-freiburg.de}}

\seealso{\code{\link{metabin}}, \code{\link{metacont}}, \code{\link{metagen}}}

\examples{
data(Olkin95)
meta1 <- metabin(event.e, n.e, event.c, n.c,
                 data=Olkin95, subset=c(41,47,51,59),
                 sm="RR", method="I",
                 studlab=paste(author, year))


##
## Do (symmetric) forest plot
##
forest(meta1)


##
## Forest plot specifying argument xlim
##
forest(meta1, xlim=c(0.01, 10))


##
## Add prediction interval to forest plot
##
forest(meta1, prediction=TRUE)


##
## Forest plot with 'classic' layout used in
## R package meta, version < 1.6-0
##
forest(meta1, col.square="black", hetstat=FALSE)


##
## Change set of columns printed on left side
## of forest plot
##
forest(meta1, comb.random=FALSE,
       leftcols="studlab")


##
## Do not print columns on right side of forest plot
##
forest(meta1, rightcols=FALSE)


##
## Change study label to "Author"
##
forest(meta1, comb.random=FALSE,
       leftlabs=c("Author", NA, NA, NA, NA))


##
## Just give effect estimate and 95% confidence interval
## on right side of forest plot
##
forest(meta1, rightcols=c("effect", "ci"))


##
## 1. Change order of columns on left side
## 2. Attach labels to columns 'event.e' and 'event.c'
##    instead of columns 'n.e' and 'n.c'
##
forest(meta1,
       leftcols=c("studlab", "n.e", "event.e", "n.c", "event.c"),
       lab.e.attach.to.col="event.e",
       lab.c.attach.to.col="event.c")


Olkin95$studlab <- paste(Olkin95$author, Olkin95$year)
##
## Add variables 'year' and 'author' to meta-analysis object
##
meta1$year <- addvar(meta1, Olkin95, "year")
meta1$author <- addvar(meta1, Olkin95, "author")

##
## Specify column labels only for newly created variables
## 'year' and 'author'
##
forest(meta1,
       leftcols=c("studlab", "event.e", "n.e", "event.c", "n.c",
                  "author", "year"),
       leftlabs=c("Author", "Year of Publ"))


##
## Change some fontsizes and fontfaces
##
forest(meta1,
       fs.study=10, ff.study="italic",
       fs.study.label=11, ff.study.label="bold",
       fs.axis=5, ff.axis="italic",
       ff.smlab="bold.italic",
       ff.fixed="plain", ff.hetstat="plain")


##
## Change some colours
##
forest(meta1,
       col.diamond="green", col.diamond.lines="red",
       col.i=c("green", "blue", "red", "orange"),
       col.square="pink", col.square.lines="black")
}

\keyword{hplot}
