% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStation.R
\name{getStation}
\alias{getStation}
\title{return metadata for selected envionmental station(s)}
\usage{
getStation(siteID, ...)
}
\arguments{
\item{siteID}{(character) in the form of: [idType]:[ID]. Required.}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata for the entered environmental monitoring site(s)
}
\description{
Return metadata of user specified environmental monitoring stations.  This is a standalone function.
}
\examples{
\dontrun{
#return metadata for NEON's CPER site
  getStation(siteID="NEON:CPER")
#return metadata for a list of sites
  getStation(siteID=c("NEON:CPER","COOP:140509", "NWSLI:LCON1"))}
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapResults}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
