% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\alias{year}
\alias{month}
\alias{day}
\alias{precision}
\title{Extracting components from messy dates}
\usage{
year(x)

month(x)

day(x)

precision(x)
}
\arguments{
\item{x}{A \code{mdate} object}
}
\value{
\code{year()}, \code{month()}, and \code{day()} extraction return the integer
for the requested date component.
\code{precision()} returns the level of greatest precision for each date.
}
\description{
These functions allow the extraction of particular date components
from messy dates, such as the \code{year()}, \code{month()}, and \code{day()}.
\code{precision()} allows for the identification of the greatest level of
precision in (currently) the first element of each date.
}
\examples{
year(as_messydate(c("2012-02-03","2012","2012-02")))
month(as_messydate(c("2012-02-03","2012","2012-02")))
day(as_messydate(c("2012-02-03","2012","2012-02")))
precision(as_messydate(c("2012-02-03","2012","2012-02")))
}
