% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/merData.R
\name{REquantile}
\alias{REquantile}
\title{Identify group level associated with RE quantile}
\usage{
REquantile(merMod, quantile, groupFctr, term = "(Intercept)")
}
\arguments{
\item{merMod}{a merMod object with one or more random effect levels}

\item{quantile}{a numeric vector with values between 0 and 100 for quantiles}

\item{groupFctr}{a character of the name of the random effect grouping factor to extract
quantiles from}

\item{term}{a character of the random effect to extract for the grouping factor
specified. Default is the intercept.}
}
\value{
a vector of the level of the random effect grouping term that corresponds
to each quantile
}
\description{
For a user specified quantile (or quantiles) of the random effect
terms in a merMod object. This allows the user to easily identify the obsevation
associated with the nth percentile effect.
}
\examples{
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
REquantile(fm1, quantile = 0.25, groupFctr = "Subject")
REquantile(fm1, quantile = 0.25, groupFctr = "Subject", term = "Days")
}

