% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.r
\docType{methods}
\name{Constructor}
\alias{Constructor}
\alias{memuse}
\alias{memuse,ANY-method}
\alias{memuse,NULL-method}
\alias{memuse,missing-method}
\alias{memuse,numeric-method}
\alias{memuse,object_size-method}
\alias{mu}
\alias{mu,ANY-method}
\alias{mu,NULL-method}
\alias{mu,missing-method}
\alias{mu,numeric-method}
\alias{mu,object_size-method}
\title{memuse Constructor}
\usage{
mu(size, unit = .UNIT, unit.prefix = .PREFIX, unit.names = .NAMES)

\S4method{mu}{ANY}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{mu}{`NULL`}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{mu}{numeric}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{mu}{object_size}(size, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{mu}{missing}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

memuse(size, unit = .UNIT, unit.prefix = .PREFIX, unit.names = .NAMES)

\S4method{memuse}{ANY}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{memuse}{`NULL`}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{memuse}{missing}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{memuse}{numeric}(size = 0, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)

\S4method{memuse}{object_size}(size, unit = .UNIT, unit.prefix = .PREFIX,
  unit.names = .NAMES)
}
\arguments{
\item{size}{\code{numeric}; indicates the unit-multiple number of bytes used
by the object.}

\item{unit}{\code{string}; the unit of storage, such as "MiB" or "MB",
depending on prefix.  Case is ignored.}

\item{unit.prefix}{\code{string}; the unit prefix, namely IEC or SI.  Case
is ignored.}

\item{unit.names}{\code{string}; control for whether the unit names should
be printed out or their abbreviation should be used.  Options are "long" and
"short", respectively.  Case is ignored.}
}
\value{
Returns a \code{memuse} class object.
}
\description{
Constructor for objects of class \code{memuse}.
}
\details{
For numeric objects, if the length is 1, then its value is used
as the number of bytes.  Otherwise, the object's memory usage
in R is taken for the size parameter.
}
\examples{
\dontrun{
### The value passed as 'size' is the number of bytes
x <- memuse(100, unit="kb")
x

y <- memuse(100, unit="kb", unit.prefix="SI")
y

### Use the memory usage of object 'size'
memuse(rnorm(1e4))
}

}
\seealso{
\code{ \link{memuse-class} \link{Accessors} \link{Converters} }
}
\keyword{Methods}

