% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\docType{methods}
\name{Replacers}
\alias{Replacers}
\alias{size<-}
\alias{size<-,memuse-method}
\alias{unit.names<-}
\alias{unit.names<-,memuse-method}
\alias{unit.prefix<-}
\alias{unit.prefix<-,memuse-method}
\alias{unit<-}
\alias{unit<-,memuse-method}
\title{Replacers}
\usage{
size(x) <- value

unit(x) <- value

unit.prefix(x) <- value

unit.names(x) <- value

\S4method{size}{memuse}(x) <- value

\S4method{unit}{memuse}(x) <- value

\S4method{unit.prefix}{memuse}(x) <- value

\S4method{unit.names}{memuse}(x) <- value
}
\arguments{
\item{x}{memuse object}

\item{value}{replacement value}
}
\value{
Returns a numeric element in the case of \code{size()}, otherwise a
string is returned.
}
\description{
Replacement methods for slots of objects of class \code{memuse}.
}
\details{
These methods are syntactic sugar for assignment using ordinary S4
accessors.  So for example, \code{size(x) <- 10} is semantically no
different from calling \code{x@size <- 10}

These methods are strict replacement methods; if you need to swap the units
of a \code{memuse} class object, you should probably be using the
\code{\link{Swaps}} methods.  See example below for further details.
}
\examples{
\dontrun{
x <- mu(2000, unit="bytes")
x

size(x) <- 1000
x
}

}
\seealso{
\code{ \link{Accessors} \link{memuse-class} }
}
\keyword{Methods}

