% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memmodel.R
\name{memmodel}
\alias{memmodel}
\alias{summary.flu,plot.flu,print.flu}
\title{Methods for influenza modelization}
\usage{
memmodel(i.data, i.seasons = 10, i.type.threshold = 5,
  i.level.threshold = 0.95, i.tails.threshold = 1,
  i.type.intensity = 6, i.level.intensity = c(0.4, 0.9, 0.975),
  i.tails.intensity = 1, i.type.curve = 2, i.level.curve = 0.95,
  i.type.other = 3, i.level.other = 0.95, i.method = 2,
  i.param = 2.8, i.centering = -1, i.n.max = -1,
  i.type.boot = "norm", i.iter.boot = 10000)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.seasons}{Maximum number of seasons to use.}

\item{i.type.threshold}{Type of confidence interval to calculate the threshold.}

\item{i.level.threshold}{Level of confidence interval to calculate the threshold.}

\item{i.tails.threshold}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.intensity}{Type of confidence interval to calculate the intensity thresholds.}

\item{i.level.intensity}{Levels of confidence interval to calculate the intensity thresholds.}

\item{i.tails.intensity}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.curve}{Type of confidence interval to calculate the modelled curve.}

\item{i.level.curve}{Level of confidence interval to calculate the modelled curve.}

\item{i.type.other}{Type of confidence interval to calculate length, start and percentages.}

\item{i.level.other}{Level of confidence interval to calculate length, start and percentages.}

\item{i.method}{Method to calculate the optimal timing of the epidemic.}

\item{i.param}{Parameter to calculate the optimal timing of the epidemic.}

\item{i.centering}{Number of weeks to center the moving seasons.}

\item{i.n.max}{Number of pre-epidemic values used to calculate the threshold.}

\item{i.type.boot}{Type of bootstrap technique.}

\item{i.iter.boot}{Number of bootstrap iterations.}
}
\value{
\code{memmodel} returns an object of class \code{mem}.
An object of class \code{mem} is a list containing at least the following components:
\itemize{
  \item{i.data} {input data}
  \item{pre.post.intervals} {Pre/post confidence intervals (Threhold is the upper limit
  of the confidence interval).}
  \item{ci.length} {Mean epidemic length confidence interval.}
  \item{ci.percent} {Mean covered percentage confidence interval.}
  \item{mean.length} {Mean length.}
  \item{moving.epidemics} {Moving epidemic rates.}
  \item{mean.start} {Mean epidemic start.}
  \item{epi.intervals} {Epidemic levels of intensity.}
  \item{typ.curve} {Typical epidemic curve.}
  \item{n.max} {Effective number of pre epidemic values.}
}
}
\description{
Function \code{memmodel} is used to calculate the threshold for influenza epidemic using historical
records (surveillance rates).

The method to calculate the threshold is described in the Moving Epidemics Method (MEM) used to
monitor influenza activity in a weekly surveillance system.
}
\details{
Input data is a data frame containing rates that represent historical influenza surveillance
data. It can start and end at any given week (tipically at week 40th), and rates can be
expressed as per 100,000 inhabitants (or per consultations, if population is not
available) or any other scale.

Parameters \code{i.type}, \code{i.type.threshold} and \code{i.type.curve} defines how to
calculate confidence intervals along the process.

\code{i.type.curve} is used for calculating the typical influenza curve,
\code{i.type.threshold} is used to calculate the pre and post epidemic threshold and
\code{i.type} is used for any other confidende interval used in the method.

All three parameters must be a number between \code{1} and \code{6}:

\itemize{
\item{1} {Arithmetic mean and mean confidence interval.}
\item{2} {Geometric mean and mean confidence interval.}
\item{3} {Median and the Nyblom/normal aproximation confidence interval.}
\item{4} {Median and bootstrap confidence interval.}
\item{5} {Arithmetic mean and point confidence interval (standard deviations).}
\item{6} {Geometric mean and point confidence interval (standard deviations).}
}

Option \code{3} uses the Hettmansperger and Sheather (1986) and Nyblom (1992) method, 
when there is enough sample size. If sample size is small, then the normal aproximation
will be used as described in Conover, 1980, p. 112. Refer to EnvStats package for
more information.

Option \code{4} uses two more parameters: \code{i.type.boot} indicates which bootstrap
method to use. The values are the same of those of the \code{\link{boot.ci}} function.
Parameter \code{i.iter.boot} indicates the number of bootstrap samples to use. See
\code{\link{boot}} for more information about this topic.

Parameters \code{i.level}, \code{i.level.threshold} and \code{i.level.curve} indicates,
respectively, the level of the confidence intervals described above.

The \code{i.n.max} parameter indicates how many pre epidemic values to use to calculate
the threshold. A value of -1 indicates the program to use an appropiate number of points
depending on the number of seasons provided as input. \code{i.tails} tells the program
to use {1} or {2} tailed confidence intervals when calculating the threshold (1 is
recommended).

Parameters \code{i.method} and \code{i.param} indicates how to find the optimal timing
of the epidemics. See \code{\link{memtiming}} for details on the values this parameters
can have.

It is important to know how to arrange information in order to use with memapp. The key points are:

\itemize{
\item One single epidemic wave each season.
\item Never delete a rate inside an epidemic.
\item Accommodate week 53.
\item Do not inflate missing values with zeroes.
}

Data must contain information from the historical series. Surveillance period can start and end at
any given week (typically start at week 40th and ends at week 20th), and data can have any units and
can be expressed in any scale (typically rates per 100,000 inhabitants or consultations).

The table must have one row per epidemiological week and one column per surveillance season. A season
is a full surveillance period from the beginning to the end, where occurs at some point one single
epidemic wave on it. No epidemic wave can be spared in two consecutive seasons. If so, you have to
redefine the start and end of the season defined in your dataset. If a season have two waves, it must
be split in two periods and must be named accordingly with the seasons name conventions described
below. Each cell contains the value for a given week in a given season.

The first column should contain the names of the weeks. When the season contains two different calendar
years, the week will go from 40th of the first year to 52nd, and then from 1st to 20th. When the season
contains one year, the weeks will go from 1st to 52nd.

Note: If there is no column with week names, the application will name the weeks numbering from 1 to
the number of rows.

\itemize{
\item In the northern hemisphere countries, the surveillance period usually goes from
week 40 to 20 of the following year (notation: season 2016/2017).
\item In the southern hemisphere countries, the surveillance period usually goes from
week 18 to 39 same year (notation: season 2017).
}

The first row must contain the names of the seasons. This application understand the naming of a
season when it contains one or two four digits year separated by / and one one-digit number
between parenthesis to identify the wave number. The wave number part in a name of a season is
used when a single surveillance period has two epidemic waves that have to be separated in order
to have reliable results. In this case, each wave is placed in different columns and named ending
with (1) for the first period, (2) for the second, and so on.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Finds the timing of the first season: 2001/2002
epi<-memmodel(flucyl)
print(epi)
summary(epi)
plot(epi)

}
\references{
Vega T, Lozano JE, Ortiz de Lejarazu R, Gutierrez Perez M. Modelling influenza epidemic - can we
detect the beginning and predict the intensity and duration? Int Congr Ser. 2004 Jun;1263:281-3.

Vega T, Lozano JE, Meerhoff T, Snacken R, Mott J, Ortiz de Lejarazu R, et al. Influenza surveillance
in Europe: establishing epidemic thresholds by the moving epidemic method. Influenza Other Respir
Viruses. 2013 Jul;7(4):546-58. DOI:10.1111/j.1750-2659.2012.00422.x.

Vega T, Lozano JE, Meerhoff T, Snacken R, Beaute J, Jorgensen P, et al. Influenza surveillance in
Europe: comparing intensity levels calculated using the moving epidemic method. Influenza Other
Respir Viruses. 2015 Sep;9(5):234-46. DOI:10.1111/irv.12330.

Lozano JE. lozalojo/mem: Second release of the MEM R library. Zenodo [Internet]. [cited 2017 Feb 1];
Available from: \url{https://zenodo.org/record/165983}. DOI:10.5281/zenodo.165983

Hettmansperger, T. P., and S. J Sheather. 1986. Confidence Intervals Based on Interpolated Order
Statistics. Statistics and Probability Letters 4: 75-79. doi:10.1016/0167-7152(86)90021-0.

Nyblom, J. 1992. Note on Interpolated Order Statistics. Statistics and Probability Letters 14:
129-31. doi:10.1016/0167-7152(92)90076-H.

Conover, W.J. (1980). Practical Nonparametric Statistics. Second Edition. John Wiley and Sons, New York.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
