% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_mean.R
\name{el_mean}
\alias{el_mean}
\title{Empirical likelihood for the mean}
\usage{
el_mean(x, par, weights = NULL, control = el_control())
}
\arguments{
\item{x}{A numeric matrix, or an object that can be coerced to a numeric
matrix. Each row corresponds to an observation. The number of rows must be
greater than the number of columns.}

\item{par}{A numeric vector of parameter values to be tested. The length of
the vector must be the same as the number of columns in \code{x}.}

\item{weights}{An optional numeric vector of weights to be used in the
fitting process. The length of the vector must be the same as the number of
rows in \code{x}. Defaults to \code{NULL}, corresponding to identical weights.
If non-\code{NULL}, weighted empirical likelihood is computed.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}
\value{
An object of class \linkS4class{EL}.
}
\description{
Computes empirical likelihood for the mean.
}
\examples{
## Scalar mean
set.seed(414)
x <- rnorm(100)
par <- 0
el_mean(x, par)

## Vector mean
x <- matrix(rnorm(100), ncol = 2)
par <- c(0, 0)
el_mean(x, par)

## Weighted data
x <- matrix(rnorm(100), ncol = 2)
par <- c(0, 0)
w <- rep(c(1, 2), each = 25)
el_mean(x, par, w)
}
\references{
Owen A (1990).
“Empirical Likelihood Ratio Confidence Regions.”
The Annals of Statistics, 18(1), 90–120.
\doi{10.1214/aos/1176347494}.
}
\seealso{
\code{\link[=el_control]{el_control()}}, \code{\link[=el_eval]{el_eval()}}, \code{\link[=elt]{elt()}}
}
