% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_na_as.R
\name{recode_na_as}
\alias{recode_na_as}
\title{Replace missing values with another value}
\usage{
recode_na_as(
  df,
  value = 0,
  subset_df = FALSE,
  tidy = FALSE,
  subset_cols = NULL,
  pattern_type = NULL,
  pattern = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{value}{The value to convert to `NA`. We can for instance change "n/a" to `NA` or any other value.}

\item{subset_df}{Logical. Use only specific columns? Defaults to FALSE. All "value"s everywhere are "recoded".}

\item{tidy}{If set to TRUE,
then one can provide additional arguments to match specific patterns using pattern and pattern_type}

\item{subset_cols}{Character. If subset_df is TRUE, then this provides the columns for which changes are required.}

\item{pattern_type}{One of contains, starts_with or ends_with. Used only if subset_cols is set to tidy.}

\item{pattern}{A character pattern to match}

\item{...}{Other arguments to other functions}
}
\value{
An object of the same type as x with NAs replaced with the desired value.
}
\description{
This provides a convenient way to recode "NA" as another value for instance "NaN", "n/a" or
any other value a user wishes to use.
}
\examples{
recode_na_as(airquality, "n/a")
recode_na_as(airquality, subset_df = TRUE,
subset_cols = "Ozone", value = "N/A")
recode_na_as(airquality, subset_df=TRUE, tidy=TRUE,
value=0, pattern_type="starts_with",
pattern="solar",ignore.case=TRUE)
}
