% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classres.R
\name{plotPerformance.classres}
\alias{plotPerformance.classres}
\title{Performance plot for classification results}
\usage{
\method{plotPerformance}{classres}(
  obj,
  nc = 1,
  type = "b",
  param = c("sensitivity", "specificity", "misclassified"),
  labels = "values",
  ylab = "",
  ylim = c(0, 1.1),
  xticks = seq_len(obj$ncomp),
  show.plot = TRUE,
  ...
)
}
\arguments{
\item{obj}{classification results (object of class \code{plsdares}, \code{simcamres}, etc.).}

\item{nc}{if there are several classes, which class to make the plot for.}

\item{type}{type of the plot}

\item{param}{which performance parameter to make the plot for (can be a vector with several values).}

\item{labels}{what to show as labels for plot objects.}

\item{ylab}{label for y axis}

\item{ylim}{vector with two values - limits for y axis}

\item{xticks}{vector with x-axis tick values}

\item{show.plot}{logical, shall plot be created or just plot series object is needed}

\item{...}{most of the graphical parameters from \code{\link{mdaplot}} function can be used.}
}
\description{
Makes a plot with classification performance parameters vs. model complexity (e.g. number of
components) for classification results.
}
\details{
See examples in description of \code{\link{plsdares}}, \code{\link{simcamres}}, etc.
}
