% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.R
\name{descfreq}
\alias{descfreq}
\title{Summarize Frequency Counts and Percentages}
\usage{
descfreq(
  data,
  denom = NULL,
  var,
  bygroup,
  format,
  fctdrop = FALSE,
  addtot = FALSE,
  na_str = NULL
)
}
\arguments{
\item{data}{(\code{data.frame})\cr a data frame that contains the variables to be
summarized and grouped.}

\item{denom}{(\code{data.frame})\cr the denominator to use for the percentage, but
not use temporarily. By default, it's NULL, meaning the function will use
the number of values of the \code{data}, including missing value.}

\item{var}{(\code{vector})\cr a character vector of variables to be summarized within \code{data}.}

\item{bygroup}{(\code{string})\cr a character variable for grouping within \code{data}.}

\item{format}{(\code{string})\cr formatting string from \code{formatters::list_valid_format_labels()}
for frequency counts and percentages.}

\item{fctdrop}{(\code{logical})\cr whether to include the levels of the variables
but with no records.}

\item{addtot}{(\code{logical})\cr whether to add total column in the output or not.}

\item{na_str}{(\code{string})\cr a string to replace \code{NA} in the output if no records
will be counted for any category.}
}
\value{
A object \code{Desc} contains an intermediate data with long form for
post-processing and final data with wide form for presentation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create a summary table for one or more variables by one group, as well as a
total column if necessary.
}
\note{
By default, the each category is sorted based on the corresponding factor
level of \code{var} variable. If the variable is not a factor, that will be sorted
alphabetically.
}
\examples{
data(adsl_sub)

# Count the age group by treatment with 'xx (xx.x\%)' format
adsl_sub \%>\%
  descfreq(
    var = "AGEGR1",
    bygroup = "TRTP",
    format = "xx (xx.x\%)"
  )

# Count the race by treatment with 'xx (xx.xx)' format and replace NA with '0'
adsl_sub \%>\%
  descfreq(
    var = "RACE",
    bygroup = "TRTP",
    format = "xx (xx.xx)",
    na_str = "0"
  )

# Count the sex by treatment adding total column
adsl_sub \%>\%
  descfreq(
    var = "SEX",
    bygroup = "TRTP",
    format = "xx (xx.x\%)",
    addtot = TRUE
  )

# Count multiple variables by treatment and sort category by corresponding factor levels
adsl_sub \%>\%
  dplyr::mutate(
    AGEGR1 = factor(AGEGR1, levels = c("<65", "65-80", ">80")),
    SEX = factor(SEX, levels = c("M", "F")),
    RACE = factor(RACE, levels = c(
      "WHITE", "AMERICAN INDIAN OR ALASKA NATIVE",
      "BLACK OR AFRICAN AMERICAN"
    ))
  ) \%>\%
  descfreq(
    var = c("AGEGR1", "SEX", "RACE"),
    bygroup = "TRTP",
    format = "xx (xx.x\%)",
    addtot = TRUE,
    na_str = "0"
  )
}
