% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_methods.R, R/qual_stat.R
\name{getAccuracy}
\alias{getAccuracy}
\alias{getAccuracy,MCTab-method}
\title{Summary Method for \code{MCTab} Objects}
\usage{
getAccuracy(object, ...)

\S4method{getAccuracy}{MCTab}(
  object,
  ref = c("r", "nr", "bnr"),
  alpha = 0.05,
  r_ci = c("wilson", "wald", "clopper-pearson"),
  nr_ci = c("wilson", "wald", "clopper-pearson"),
  bnr_ci = "bootstrap",
  bootCI = c("perc", "norm", "basic", "stud", "bca"),
  nrep = 1000,
  rng.seed = NULL,
  digits = 4,
  ...
)
}
\arguments{
\item{object}{(\code{MCTab})\cr input from \link{diagTab} function to create 2x2 contingency table.}

\item{...}{other arguments to be passed to \link[DescTools:BinomCI]{DescTools::BinomCI}.}

\item{ref}{(\code{character})\cr reference condition. It is possible to choose one
condition for your require. The \code{r} indicates that the comparative test is standard
reference, \code{nr} indicates the comparative test is not a standard reference, and
\code{bnr} indicates both the new test and comparative test are not references.}

\item{alpha}{(\code{numeric})\cr type-I-risk, \eqn{\alpha}.}

\item{r_ci}{(\code{string})\cr string specifying which method to calculate the
confidence interval for a diagnostic test with reference/gold standard. Default
is \code{wilson}. Options can be \code{wilson}, \code{wald} and \code{clopper-pearson}, see \link[DescTools:BinomCI]{DescTools::BinomCI}.}

\item{nr_ci}{(\code{string})\cr string specifying which method to calculate the
confidence interval for the comparative test with non-reference standard. Default
is \code{wilson}. Options can be \code{wilson}, \code{wald} and \code{clopper-pearson}, see \link[DescTools:BinomCI]{DescTools::BinomCI}.}

\item{bnr_ci}{(\code{string})\cr string specifying which method to calculate the
confidence interval for both tests are not reference like reader precision. Default
is \code{bootstrap}. But when the point estimate of \code{ANA} or \code{APA} is equal to 0 or 100\%,
the method will be changed to \verb{transformed wilson}.}

\item{bootCI}{(\code{string})\cr string specifying the which bootstrap confidence
interval from \code{boot.ci()} function in \code{boot} package. Default is
\code{perc}(bootstrap percentile), options can be \code{norm}(normal approximation),
\code{boot}(basic bootstrap), \code{stud}(studentized bootstrap) and \code{bca}(adjusted
bootstrap percentile).}

\item{nrep}{(\code{integer})\cr number of replicates for bootstrapping, default is 1000.}

\item{rng.seed}{(\code{integer})\cr number of the random number generator seed
for bootstrap sampling. If set to NULL currently in the R session used RNG
setting will be used.}

\item{digits}{(\code{integer})\cr the desired number of digits. Default is 4.}
}
\value{
A data frame contains the qualitative diagnostic accuracy criteria with
three columns for estimated value and confidence interval.
\itemize{
\item sens: Sensitivity refers to how often the test is positive when the condition
of interest is present.
\item spec: Specificity refers to how often the test is negative when the condition
of interest is absent.
\item ppv: Positive predictive value refers to the percentage of subjects with
a positive test result who have the target condition.
\item npv: Negative predictive value refers to the percentage of subjects with
a negative test result who do not have the target condition.
\item plr: Positive likelihood ratio refers to the probability of true positive
rate divided by the false negative rate.
\item nlr: Negative likelihood ratio refers to the probability of false positive
rate divided by the true negative rate.
\item ppa: Positive percent agreement, equals to sensitivity when the candidate method
is evaluated by comparison with a comparative method, not reference/gold standard.
\item npa: Negative percent agreement, equals to specificity when the candidate method
is evaluated by comparison with a comparative method, not reference/gold standard.
\item opa: Overall percent agreement.
\item apa: Average positive agreement refers to the positive agreements and can be
regarded as weighted ppa.
\item ana: Average negative agreement refers to the negative agreements and can be
regarded as weighted npa.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Provides a concise summary of the content of \code{\link{MCTab}} objects. Computes
sensitivity, specificity, positive and negative predictive values and positive
and negative likelihood ratios for a diagnostic test with reference/gold standard.
Computes positive/negative percent agreement, and overall percent agreement
when the new test is evaluated by comparison to a non-reference standard. Computes
average positive/negative agreement when the both tests are all not the
reference, such as paired reader precision.
}
\examples{
# For qualitative performance
data("qualData")
tb <- qualData \%>\%
  diagTab(
    formula = ~ CandidateN + ComparativeN,
    levels = c(1, 0)
  )
getAccuracy(tb, ref = "r")
getAccuracy(tb, ref = "nr", nr_ci = "wilson")

# For Between-Reader precision performance
data("PDL1RP")
reader <- PDL1RP$btw_reader
tb2 <- reader \%>\%
  diagTab(
    formula = Reader ~ Value,
    bysort = "Sample",
    levels = c("Positive", "Negative"),
    rep = TRUE,
    across = "Site"
  )
getAccuracy(tb2, ref = "bnr")
getAccuracy(tb2, ref = "bnr", rng.seed = 12306)
}
