% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\encoding{UTF-8}
\name{get_quantiles}
\alias{get_quantiles}
\title{Expand samples with quantiles}
\usage{
get_quantiles(samples, quantiles, xvar, yvar, facet_by = NULL)
}
\arguments{
\item{samples}{A tidybayes tibble}

\item{quantiles}{Vector of quantiles (0.0 to 1.0)}

\item{xvar}{An rlang::sym() with the name of the x-col in \code{samples}}

\item{yvar}{An rlang::sym() with the name of the response col in \code{samples}}

\item{facet_by}{String. Name of a varying group.}
}
\value{
A tidybayes long format tibble with the column "quantile"
}
\description{
TO DO: implement using \code{fitted()} and \code{predict()} but avoid double-computing the samples? E.g.:
\verb{get_quantiles2 = function(fit, quantiles, facet_by = NULL) \{}
\verb{fitted(fit, probs = c(0.1, 0.5, 0.9), newdata = data.frame(x = c(11, 50, 100))) \%>\%}
\verb{tidyr::pivot_longer(tidyselect::starts_with("Q")) \%>\%}
\code{dplyr::mutate(quantile = stringr::str_remove(name, "Q") \%>\% as.numeric() / 100)}
\verb{\}}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
