\name{denoverplot1}
\alias{denoverplot1}
\title{ Plot Overlaying Densities }

\description{
  Creates a plot containing overlaying kernel density estimates from different MCMC simulations.  This function is used in the \code{denoverplot} function to produce plots of overlaying densities for parameters in common from two different MCMC simulations.
}

\usage{
denoverplot1(\dots, col = mcmcplotsPalette(n), lty = 1, style = c("gray", "plain"), gpar = NULL)}

\arguments{
  \item{\dots}{ one or more vectors or a list containing one or more vectors to be plotted.}
  \item{col}{ one or more colors for the densities.}
  \item{lty}{ types of lines to plot.}
  \item{style}{ if "gray", then the plotting region is printed with a gray background, otherwise the default plotting region is used.}
  \item{gpar}{ a list of additional graphical parameters to be passed to the plotting function.  See help for \code{par}.}
}

\details{
  None.
}

\value{
  Creates a plot.
}

\references{ None }

\author{ S. McKay Curtis }

\note{
  None.
}

\seealso{
  \code{\link{denoverplot}}
}

\examples{
denoverplot1(rnorm(1000), rnorm(1000))
denoverplot1(rnorm(1000, 0.0, 1.0), rnorm(1000, 0.1, 1.0), style="plain")
denoverplot1(list(rgamma(1000, 1, 1), rgamma(1000, 1, 1)))
}

\keyword{ hplot }
