% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplibrary.R
\name{byte_mutation_random_dynamic}
\alias{byte_mutation_random_dynamic}
\title{Performs mutation operation on a given double vector with dynamic mutation probabilities}
\usage{
byte_mutation_random_dynamic(object, parent, ...)
}
\arguments{
\item{object}{A \code{GA::ga} object}

\item{parent}{Index of the candidate solution of the current population}

\item{...}{Additional arguments to be passed to the function}
}
\value{
Mutated double vector
}
\description{
This function is not called directly but is given as a parameter in \code{GA::ga} function. 
In \code{GA::ga}, if the parameter \code{mutation=} is set to \code{byte_mutation_random_dynamic} than
the byte-coded mutation operator with dynamic probabilities is applied in the genetic search. In \code{mcga2} function, the hard-coded 
mutation parameter is set to byte_mutation by definition. This function simply takes an double vector and
changes bytes randomly in the range of [0,255] using the descrasing values of pre-determined mutation probabilty by generations.
}
\examples{
f <- function(x){ 
  return(-sum( (x-5)^2 ) )
}
# Increase popSize and maxiter for more precise solutions
myga <- GA::ga(type="real-valued", fitness = f, popSize = 100, maxiter = 200, 
              min = rep(-50,5), max = rep(50,5), crossover = byte_crossover,
              mutation = byte_mutation_random_dynamic, pmutation = 0.20)
print(myga@solution)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\references{
M.H.Satman (2013), Machine Coded Genetic Algorithms for Real Parameter Optimization Problems, Gazi University Journal of Science, Vol 26, No 1, pp. 85-95
}

