% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliffpie.R
\name{cliffpie}
\alias{cliffpie}
\title{Compute Point and Interval Estimates of Cliff's delta}
\usage{
cliffpie(v1, v0, nboot = 1999, conf.level = 0.95, seed = 1)
}
\arguments{
\item{v1}{a vector, biomarker values from the treatment group.}

\item{v0}{a vector, biomarker values from the control group.}

\item{nboot}{an integer, the number of bootstrap samples. The default value
is 1999.}

\item{conf.level}{a numeric, the confidence level. The default value is 0.95.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}
}
\value{
\code{cliffpie} returns a one row data frame with three numerics:
  \item{\code{delta}}{the Cliff's delta of the treatment group.}
  \item{\code{ci.lower}}{the lower bound of the confidence interval.}
  \item{\code{ci.upper}}{the upper bound of the confidence interval.}
}
\description{
\code{cliffpie} calculates Cliff's delta and its bias-corrected and
accelerated bootstrap confidence interval.
}
\examples{
cliffpie(sokolova2019[7:12, 3], sokolova2019[1:6, 3])

}
\references{
Efron, B., & Tibshirani, R. (1993). An introduction to the
  bootstrap. Chapman & Hall. \cr \cr Ruscio, J., & Mullen, T. (2012).
  Confidence Intervals for the Probability of Superiority Effect Size Measure
  and the Area Under a Receiver Operating Characteristic Curve. Multivariate
  Behavioral Research, 47(2), 201–223.
  \doi{10.1080/00273171.2012.658329}.
}
\seealso{
\code{\link[RProbSup]{A1}} and \code{\link[orddom]{dmes.boot}}.
}
