% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_beast2_pkg_names.R
\name{get_beast2_pkg_names}
\alias{get_beast2_pkg_names}
\title{Get all BEAST2 package names}
\usage{
get_beast2_pkg_names(has_internet = curl::has_internet())
}
\arguments{
\item{has_internet}{boolean to indicate if the user has access to the
internet. By default, this value equals the result
of \code{curl::has_internet}}
}
\value{
a data frame with columns\cr
\enumerate{
  \item name package name, for example, code{bdmm}
  \item installed_version the installed version, for example, \code{2.6.2}.
    \code{installed_version} will be NA if the package is not installed
  \item latest_version version number of the latest version, for example,
    \code{2.6.3}
  \item dependencies packages the package depends on, for example
    \code{BEASTLabs, GEO_SPHERE}. \code{dependencies} will be empty if there
    are no dependencies
  \item description description of the package, for example
    \code{Nested sampling for model selection and posterior inference}
}
}
\description{
List all BEAST2 packages that are available and installed.
Will \link{stop} if there is no internet connection
}
\examples{
if (is_beast2_installed() && curl::has_internet()) {
  get_beast2_pkg_names()
}
}
\author{
Richèl J.C. Bilderbeek
}
