% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matsindf_apply.R
\name{where_to_get_args}
\alias{where_to_get_args}
\title{Decide where to get each argument to FUN}
\usage{
where_to_get_args(.dat = NULL, FUN, ...)
}
\arguments{
\item{.dat}{The \code{.dat} argument to \code{matsindf_apply()}.}

\item{FUN}{The \code{FUN} argument to \code{matsindf_apply()}.}

\item{...}{The \code{...} argument to \code{matsindf_apply()}.}
}
\value{
A named list wherein the names are the argument names to \code{FUN}.
Values are character vectors with 2 elements.
The first element is named \code{source} and provides
the argument to \code{matsindf_apply()} from which the named argument should be found,
one of ".dat", "FUN", or "...".
The second element is named \code{arg_name} and provides
the variable name or argument name in the source that contains the input data
for the argument to \code{FUN}.
}
\description{
The precedence rules for where to obtain values for the \code{FUN} argument to
\code{matsindf_apply()} are codified here.
The rules are:
\itemize{
\item Precedence order: \code{...}, \code{.dat}, defaults arguments to \code{FUN}
(highest priority to lowest priority).
\item If an element of \code{...} is a character string of length \code{1},
the element of \code{...} provides a mapping between
an item in \code{.dat} (with same name as the value of the character string of length \code{1})
to an argument of \code{FUN} (with the same name as the name of the character string of length \code{1}).
\item If the value of the character string of length \code{1} is not a name in \code{.dat},
the default arguments to \code{FUN} are checked in this order.
\itemize{
\item If the name of a default argument to \code{FUN} is the same as the value of the
string of length \code{1} argument in \code{...}, a mapping occurs.
\item If a mapping is not possible,
the default arg to \code{FUN} is used directly.
}
}
}
\examples{
example_fun <- function(a = 1, b) {
  list(c = a + b, d = a - b)
}
# b is not available anywhere, likely causing an error later
matsindf:::where_to_get_args(FUN = example_fun)
# b is now available in ...
matsindf:::where_to_get_args(FUN = example_fun, b = 2)
# b is now available in .dat
matsindf:::where_to_get_args(list(b = 2), FUN = example_fun)
# b now comes from ..., because ... takes precedence over .dat
matsindf:::where_to_get_args(list(b = 2), FUN = example_fun, b = 3)
# Mapping from c in .dat to b in FUN
matsindf:::where_to_get_args(list(c = 2),
                             FUN = example_fun, b = "c")
# Redirect from an arg in ... to a different default to FUN
matsindf:::where_to_get_args(FUN = example_fun, b = "a")
# b is found in FUN, not in .dat, because the mapping (b = "a")
# is not available in .dat
matsindf:::where_to_get_args(list(b = 2), FUN = example_fun, b = "a")
}
