% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_to_tidy}
\alias{expand_to_tidy}
\title{Expand a "tidy" data frame with matsindf-style matrices to a "tidy" data frame with each matrix entry as an observation}
\usage{
expand_to_tidy(
  .DF,
  matnames = "matnames",
  matvals = "matvals",
  rownames = "rownames",
  colnames = "colnames",
  rowtypes = "rowtypes",
  coltypes = "coltypes",
  drop = NA
)
}
\arguments{
\item{.DF}{the data frame containing \pkg{matsindf}-style matrices.
(\code{.DF} may also be a named list of matrices, in which case
names of the matrices are taken from the names of items in the list and
list items are expected to be matrices.)}

\item{matnames}{name of the column in \code{.DF} containing matrix names (a string).
Default is "\code{matnames}".}

\item{matvals}{name of the column in \code{.DF} containing IO-style matrices or constants (a string),
This will also be the name of the column containing matrix entries in the output data frame.
Default is "\code{matvals}".}

\item{rownames}{name for the output column of row names (a string).
Default is "\code{rownames}".}

\item{colnames}{name for the output column of column names (a string).
Default is "\code{colnames}".}

\item{rowtypes}{optional name for the output column of row types (a string).
Default is "\code{rowtypes}".}

\item{coltypes}{optional name for the output column of column types (a string)
Default is "\code{coltypes}".}

\item{drop}{if specified, the value to be dropped from output,
For example, \code{drop = 0} will cause \code{0} entries in the matrices to be deleted from output.
If \code{NA}, no values are dropped from output.
Default is \code{NA}.}
}
\value{
a tidy data frame containing expanded \pkg{matsindf}-style matrices
}
\description{
A data frame with \pkg{matsindf}-style matrices contains matrices with names \code{matnames}
in the column specified by \code{matvals}).
An IO-style matrix has named rows and columns.
In addition, \pkg{matsindf}-style matrices have "types" for row and column information, such as "Commodities", "Industries",
"Products", or "Machines".
}
\details{
Names for output columns are specified in the \code{rownames}, \code{colnames},
\code{rowtypes}, and \code{coltypes}, arguments.
The entries of the \pkg{matsindf}-style matrices are stored in an output column named \code{values}.
}
\examples{
library(dplyr)
library(matsbyname)
ptype <- "Products"
itype <- "Industries"
tidy <- data.frame(Country  = c( "GH",  "GH",  "GH",  "GH",  "GH",  "GH",  "GH",
                                 "US",  "US",  "US",  "US", "GH", "US"),
                  Year      = c( 1971,  1971,  1971,  1971,  1971,  1971,  1971,
                                 1980,  1980,  1980,  1980, 1971, 1980),
                  matrix    = c(  "U",   "U",   "Y",   "Y",   "Y",   "V",   "V",
                                  "U",   "U",   "Y",   "Y", "eta", "eta"),
                  row       = c(  "c1",  "c2",  "c1",  "c2",  "c2",  "i1",  "i2",
                                  "c1",  "c1",  "c1",  "c2", NA, NA),
                  col       = c(  "i1",  "i2",  "i1",  "i2",  "i3",  "c1",  "c2",
                                  "i1",  "i2",  "i1",  "i2", NA, NA),
                  rowtypes  = c( ptype, ptype, ptype, ptype, ptype, itype, itype,
                                 ptype, ptype, ptype, ptype, NA, NA),
                  coltypes  = c(itype, itype, itype, itype, itype, ptype, ptype,
                                itype, itype, itype, itype, NA, NA),
                  vals  = c(    11  ,  22,    11 ,   22 ,   23 ,   11 ,   22 ,
                                11 ,   12 ,   11 ,   22,   0.2, 0.3)) \%>\%
  group_by(Country, Year, matrix)
mats <- collapse_to_matrices(tidy, matnames = "matrix", rownames = "row", colnames = "col",
                             rowtypes = "rowtypes", coltypes = "coltypes",
                             matvals = "vals") \%>\%
  ungroup()
expand_to_tidy(mats, matnames = "matrix", matvals = "vals",
                     rownames = "rows", colnames = "cols",
                     rowtypes = "rt",   coltypes = "ct")
expand_to_tidy(mats, matnames = "matrix", matvals = "vals",
                     rownames = "rows", colnames = "cols",
                     rowtypes = "rt",   coltypes = "ct", drop = 0)
}
