% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{invert_byname}
\alias{invert_byname}
\title{Invert a matrix}
\usage{
invert_byname(a)
}
\arguments{
\item{a}{the matrix to be inverted. \code{a} must be square.}
}
\value{
the inversion of \code{a}
}
\description{
This function transposes row and column names as well as row and column types.
Rows and columns of \code{a} are sorted prior to inverting.
}
\examples{
m <- matrix(c(10,0,0,100), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 1:2))) \%>\%
  setrowtype("Industry") \%>\% setcoltype("Commodity")
invert_byname(m)
matrixproduct_byname(m, invert_byname(m))
matrixproduct_byname(invert_byname(m), m)
invert_byname(list(m,m))
}
