% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{group_by}
\alias{group_by}
\alias{row_group_by}
\alias{column_group_by}
\alias{row_ungroup}
\alias{column_ungroup}
\title{Group rows/columns of a matrixset by one or more variables}
\usage{
row_group_by(.ms, ..., .add = FALSE, .drop = row_group_by_drop_default(.ms))

column_group_by(
  .ms,
  ...,
  .add = FALSE,
  .drop = column_group_by_drop_default(.ms)
)

row_ungroup(.ms, ...)

column_ungroup(.ms, ...)
}
\arguments{
\item{.ms}{A \code{matrixset} object}

\item{...}{In \code{\link[=row_group_by]{row_group_by()}} or \code{\link[=column_group_by]{column_group_by()}}, annotation
variables to use for grouping. These variables are the ones
returned by \code{\link[=row_traits]{row_traits()}} or \code{\link[=column_traits]{column_traits()}}. In \code{\link[=row_ungroup]{row_ungroup()}}
or \code{\link[=column_ungroup]{column_ungroup()}}, variables to remove from grouping. If
not provided, grouping is removed altogether.}

\item{.add}{\code{logical}. The default, \code{FALSE}, means that previous groups
are overwritten. Setting \code{.add} to \code{TRUE} will add to the
existing groups.}

\item{.drop}{\code{logical}. When grouping by \code{factor} annotations, should
levels that do not appear in the data be dropped? The default
is \code{TRUE}, unless \code{.ms} has been previously grouped with
\code{.drop = FALSE}.}
}
\value{
A grouped \code{matrixset} with class \code{row_grouped_ms}, unless \code{.ms} was already
column-grouped via \code{\link[=column_group_by]{column_group_by()}}, in which case a \code{dual_grouped_ms}
\code{matrixset} is returned.

If the combination of \code{...} and \code{.add} yields an empty set of grouping
columns, a regular \code{matrixset}or a \code{col_grouped_ms}, as appropriate, will be
returned.
}
\description{
Applying \code{\link[=row_group_by]{row_group_by()}} or \code{\link[=column_group_by]{column_group_by()}} to a \code{matrixset} object
registers this object as one where certain operations are performed per
(row or column) group.

To (partly) remove grouping, use \code{\link[=row_ungroup]{row_ungroup()}} or \code{\link[=column_ungroup]{column_ungroup()}}.

These functions are the \code{matrixset} equivalent of \code{dplyr}'s
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:group_by]{dplyr::ungroup()}}
}
\examples{
by_class <- row_group_by(student_results, class)

# On it's own, a grouped `matrixset` looks like a regular `matrixset`, except
# that the grouping structure is listed
by_class

# Grouping changes how some functions operates
filter_row(by_class, previous_year_score > mean(previous_year_score))

# You can group by expressions: you end-up grouping by the new annotation:
row_group_by(student_results, sqrt_score = sqrt(previous_year_score))

# By default, grouping overrides existing grouping
row_group_vars(row_group_by(by_class, teacher))

# Use .add = TRUE to instead append
row_group_vars(row_group_by(by_class, teacher, .add = TRUE))
# To removing grouping, use ungroup
row_ungroup(by_class)

}
