% Generated by roxygen2 (4.0.2): do not edit by hand
\name{outer.RGCCA}
\alias{outer.RGCCA}
\title{RGCCA outer estimation (Experimental)}
\usage{
outer.RGCCA(S, W, E, W.mod, ..., tau = 1)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{E}{Inner weight matrix. A square matrix of inner estimates between the composites.}

\item{W.mod}{A matrix specifying the weight relationships and their starting values.}

\item{...}{Other parameters are ignored}

\item{tau}{The shrinkage parameter (0-1)}
}
\value{
A matrix of unscaled outer weights \code{W} with the same dimesions as \code{W.mod}.
}
\description{
Implements the second step of the RGCCA estimation describe by Tenenhaus & Tenehaus (2011)
}
\details{
The second step of RGCCA estimation method, as describe by Tenenhaus & Tenehaus (2011)
}
\examples{
# Runs the example from the rgcca function of the RGCCA package

if(require(RGCCA) & require(Matrix)) {
  
  data(Russett)
  X_agric =as.matrix(Russett[,c("gini","farm","rent")])
  X_ind = as.matrix(Russett[,c("gnpr","labo")])
  X_polit = as.matrix(Russett[ , c("demostab", "dictatur")])
  A = list(X_agric, X_ind, X_polit)
  #Define the design matrix (output = C)
  C = matrix(c(0, 0, 1, 0, 0, 1, 1, 1, 0), 3, 3)
  
  tau <- 0
  
  result.rgcca = rgcca(A, C, tau =rep(tau,3), scheme = "factorial", scale = TRUE)
  
  W.rgcca <- as.matrix(bdiag(lapply(result.rgcca$a, function(x){matrix(x,nrow=1)})))
  
  # Do the same with matrixpls
  
  W.mod <- (W.rgcca != 0) *1
  
  S <- cov(do.call(cbind,A))
  W.matrixpls <- weight.pls(S, list(inner = C,
                                    reflective = t(W.mod),
                                    formative = matrix(0,nrow(W.mod), ncol(W.mod))),
                            W.mod = W.mod,
                            innerEstimator = inner.factor,
                            outerEstimators = outer.RGCCA, tau = tau)
  
  print(W.rgcca)
  print(W.matrixpls)
  
  # Do we get perfect correlations for the composites
  cor(do.call(cbind,result.rgcca$Y), do.call(cbind,A) \%*\% t(W.matrixpls))
}
}
\references{
Tenenhaus, A., & Tenenhaus, M. (2011). Regularized Generalized Canonical
Correlation Analysis. Psychometrika, 76(2), 257–284.
doi:10.1007/s11336-011-9206-8
}
\seealso{
Other outer estimators: \code{\link{outer.GSCA}};
  \code{\link{outer.factor}};
  \code{\link{outer.fixedWeights}};
  \code{\link{outer.modeA}}; \code{\link{outer.modeB}}
}

