% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fligner.R
\name{fligner}
\alias{fligner}
\alias{row_flignerkilleen}
\alias{col_flignerkilleen}
\title{Fligner-Killeen test}
\usage{
row_flignerkilleen(x, g)

col_flignerkilleen(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of the
Fligner-Killeen test performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
3. df - degrees of freedom\cr
4. statistic - squared statistic\cr
5. pvalue - p-value
}
\description{
Performs the Fligner-Killeen test of homogeneity of variances (with median
centering of the groups) on each row/column of the input matrix.
}
\details{
NA values are always ommited. If values are missing for a whole group - that
group is discarded. Groups with only one observation are also discarded.

\code{row_flignerkilleen(x, g)} - Fligner-Killeen test on rows.
\code{col_flignerkilleen(x, g)} - Fligner-Killeen test on columns.

Results should be the same as as running \code{fligner.test(x, g)}
on every row (or column) of \code{x}.
}
\examples{
col_flignerkilleen(iris[,1:4], iris$Species)
row_flignerkilleen(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{fligner.test()}
}
\author{
Karolis Koncevičius
}
