% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\name{computeABCXYZAnalysis}
\alias{computeABCXYZAnalysis}
\title{Performs an ABC/XYZ analysis}
\usage{
computeABCXYZAnalysis(
  data,
  value,
  item,
  timestamp,
  temporalAggregation = c("day", "week", "month", "quarter", "year"),
  AB = 80,
  BC = 95,
  XY = NA,
  YZ = NA,
  ignoreZeros = FALSE
)
}
\arguments{
\item{data}{Data frame or matrix on which the ABC analysis is performed.}

\item{value}{Name of the column variable that contains the value for the ABC and XYZ analysis.}

\item{item}{Names of the columns including the item names or identifiers (e.g., product name, EAN).}

\item{timestamp}{Name of the column including the timestamp. This column should be in POSIX or date-format.}

\item{temporalAggregation}{Temporal aggregation for the XYZ-analysis (i.e., "day", "week", "month", "quarter", "year").}

\item{AB}{Threshold (in percent) between category A and B.}

\item{BC}{Threshold (in percent) between category B and C.}

\item{XY}{Threshold (in percent) between category X and Y.}

\item{YZ}{Threshold (in percent) between category Y and Z.}

\item{ignoreZeros}{Whether zero values should be ignored in XYZ-analysis.}
}
\value{
Returns an \code{ABCXYZData} object.
}
\description{
Divides a given data frame into 3 classes, A, B, C, according to the value of one column (e.g., revenue).
}
\examples{
# ABC Analysis
data("Amount")
abcResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date")

# ABC/XYZ Analysis
data("Amount")
abcxyzResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    XY = 0.3, YZ = 0.5)
}
\seealso{
\code{\link[=ABCXYZData-class]{ABCXYZData}} \code{\link[=ABCXYZData-class]{summary}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
