% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{cofactor}
\alias{cofactor}
\title{Cofactor of A[i,j]}
\usage{
cofactor(A, i, j)
}
\arguments{
\item{A}{a square matrix}

\item{i}{row index}

\item{j}{column index}
}
\value{
the cofactor of A[i,j]
}
\description{
Returns the cofactor of element (i,j) of the square matrix A, i.e., the signed minor of the
submatrix that results when row i and column j are deleted.
}
\examples{
M <- matrix(c(4, -12, -4,
              2,   1,  3,
             -1,  -3,  2), 3, 3, byrow=TRUE)
cofactor(M, 1, 1)
cofactor(M, 1, 2)
cofactor(M, 1, 3)

}
\author{
Michael Friendly
}
\seealso{
\code{\link{row_cofactors}} for all cofactors of a given row

Other determinants: \code{\link{minor}},
  \code{\link{row_cofactors}}, \code{\link{row_minors}}
}

