% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScene.R
\name{plotScene}
\alias{plotScene}
\title{graphical visualization of a mating scene object}
\usage{
plotScene(
  scene,
  dimension = "auto",
  dailyPoints = TRUE,
  drawQuartiles = TRUE,
  sortBy = c("start", "end"),
  colorBy = NULL,
  sub = NULL,
  N = 3,
  label.sub = TRUE,
  xlab.spat = NULL,
  ylab.spat = NULL,
  pch = 19,
  pt.cex = 0.75,
  label.cex = 0.8,
  plot.lim.zoom = FALSE,
  quartile.lwd = 1,
  quartile.col = "gray55",
  peak.col = "gray27",
  labelID = FALSE,
  mt1 = "F",
  mt2 = "M",
  leg.ncol = 1,
  ...
)
}
\arguments{
\item{scene}{a matingScene object}

\item{dimension}{what dimension(s) of the mating scene should be visualized. Possible dimensions are 't' for temporal, 's' for spatial, 'mt' for mating type, and 'auto' (the default). For dimension = 'auto', all dimensions represented in the mating scene object will be plotted.}

\item{dailyPoints}{logical indicating whether daily counts of individuals should be displayed for plots of the temporal dimension}

\item{drawQuartiles}{logical indicating whether vertical lines should be drawn at population peak (see details) or quartiles}

\item{sortBy}{character indicating which columns to sort segments of flowering schedule by. Defaults to 'start', then 'end'. Up to three variables may be specified.}

\item{colorBy}{character optional, the name of a variable to use to assign color to segments or points.}

\item{sub}{a vector containing the ids of individuals to be highlighted in the plots or a character string specifying how to choose individuals to highlight. Possible values are "random" or "all". If NULL, no subset will be identified in the plots.}

\item{N}{a positive number, the number of individuals to sample if \code{sub} = 'random'}

\item{label.sub}{logical, indicating whether specified subset should be labeled}

\item{xlab.spat}{character label for x-axis of spatial dimension plots. If NULL, defaults to 'easting'.}

\item{ylab.spat}{character label for y-axis of spatial dimension plots. If NULL, defaults to 'northing'.}

\item{pch}{specify point type to be used in plots. Defaults to pch = 19 (filled-in circle). If NULL, points will be labeled with their id.}

\item{pt.cex}{specify point expansion factor (point size relative to device default)}

\item{label.cex}{specify text expansion factor (text size relative to device default)}

\item{plot.lim.zoom}{if TRUE, spatial plot limits for lists of scenes are set by the maximum from all scenes}

\item{quartile.lwd}{if \code{drawQuartiles} = TRUE, specifies weight of quartile and peak lines relative to device default.}

\item{quartile.col}{if \code{drawQuartiles} = TRUE, specifies color of quartile lines, defaults to 'gray81'.}

\item{peak.col}{if \code{drawQuartiles} = TRUE, specify color of peak lines, defaults to 'gray27'.}

\item{labelID}{if TRUE, the y-axis will be labeled with the id of the corresponding segment.}

\item{mt1}{label for mating type '1', if dioecious}

\item{mt2}{label for mating type '2', if dioecious}

\item{leg.ncol}{number of columns to include in legend, if colorBy is not NULL}

\item{...}{standard graphical parameters}
}
\value{
No return value, called to draw a plot
}
\description{
Visualize a mating scene
}
\details{
Population peak is defined by when maximum number individuals were reproductively receptive on one day. If multiple days had the same maximum number, peak is defined as the median of these dates.
}
\examples{
pop <- simulateScene()
plotScene(pop)


}
\seealso{
see \code{\link{plot3DScene}} to visualize multiple dimensions on one plot
}
\author{
Amy Waananen
}
