% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convData.R
\name{makeDataMap}
\alias{makeDataMap}
\title{Make the maps for the data}
\usage{
makeDataMap(leftSym, rightSym, rClass, matClass = "")
}
\arguments{
\item{leftSym}{The left symbol that contains the Matlab data}

\item{rightSym}{the right symbol that contains the Matlab data}

\item{rClass}{The formal r class name that defines what the R data is
outputted as}

\item{matClass}{The name of the Matlab class that should be converted}
}
\value{
A function that takes in a Matlab lines and changes the data into R
  data lines
}
\description{
Make the maps for the data
}
\details{
The requirements for conversion are the bounds given by both left
  and right symbols or the MatLab class. The Matlab class allows for the
  conversion of structures but is really just a dictionary for the different
  bounds.
}
\examples{
	 dataMap <- makeDataMap("[", "]", "matrix")
	 dataMap("thing <- [23,2, 3.2; 7, 6, 8]")
	 # "thing <- matrix(c(23, 2, 3.2, 7, 6, 8), nrow = 2, ncol = 3)"
	 
	 dataMap <- makeDataMap(rClass = "list", matClass = "cell")
	 dataMap("otherThing <- {23,2, '3.2'; NaN, 6, 8}")
	 # "otherThing <- list(list(23, 2, '3.2'), list(NaN, 6, 8))"
}

