/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.IConstraintList;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.iterators.IVIterator;

public class IntegerVariable
extends IntegerExpressionVariable {
    protected int[] values;
    protected IVIterator _iterator;

    protected IntegerVariable(VariableType variableType, int[] parameters, boolean enableOption, IConstraintList constraints) {
        super(variableType, (Object)parameters, enableOption, constraints);
        if (parameters.length > 0) {
            this.lowB = parameters[0];
            this.uppB = parameters[parameters.length - 1];
        }
        this.setVariables(this);
    }

    public IntegerVariable(String name, int binf, int bsup) {
        this(VariableType.INTEGER, new int[]{binf, bsup}, true, (IConstraintList)new ComponentVariable.ConstraintsDataStructure());
        this.setName(name);
    }

    public IntegerVariable(String name, int[] theValues) {
        this(VariableType.INTEGER, theValues, true, (IConstraintList)new ComponentVariable.ConstraintsDataStructure());
        this.values = theValues;
        this.setName(name);
    }

    public final int[] getValues() {
        return this.values;
    }

    public final int getDomainSize() {
        if (this.values != null) {
            return this.values.length;
        }
        return this.getUppB() - this.getLowB() + 1;
    }

    public final boolean canBeEqualTo(int v) {
        if (this.values != null) {
            for (int value : this.values) {
                if (value != v) continue;
                return true;
            }
            return false;
        }
        return v >= this.getLowB() && v <= this.getUppB();
    }

    public final boolean isBoolean() {
        return this.getLowB() == 0 && (this.getUppB() == 0 || this.getUppB() == 1) || this.getLowB() == 1 && this.getUppB() == 1;
    }

    public final boolean isConstant() {
        return this.getLowB() == this.getUppB();
    }

    @Override
    public String pretty() {
        return this.name + " [" + this.getLowB() + ", " + this.getUppB() + ']';
    }

    public final DisposableIntIterator getDomainIterator() {
        if (this._iterator == null || !this._iterator.reusable()) {
            this._iterator = new IVIterator();
        }
        this._iterator.init(this.lowB, this.uppB, this.values);
        return this._iterator;
    }

    @Override
    public Variable[] doExtractVariables() {
        return this.getVariables();
    }

    public final void removeVal(int remvalue) {
        if (this.canBeEqualTo(remvalue)) {
            int[] vals;
            int size;
            if (this.values == null) {
                size = this.getUppB() - this.getLowB();
                vals = new int[size];
                int idx = 0;
                int val = this.getLowB();
                while (idx < size) {
                    if (val != remvalue) {
                        vals[idx++] = val;
                    }
                    ++val;
                }
            } else {
                size = this.values.length - 1;
                vals = new int[size];
                int idx = 0;
                for (int value : this.values) {
                    if (value == remvalue) continue;
                    vals[idx++] = value;
                }
            }
            this.values = vals;
            this.setLowB(this.values[0]);
            this.setUppB(this.values[size - 1]);
        }
    }

    public final int[] enumVal() {
        if (this.values == null) {
            int[] val = new int[this.getUppB() - this.getLowB() + 1];
            for (int o = 0; o < val.length; ++o) {
                val[o] = this.getLowB() + o;
            }
            return val;
        }
        if (this.values.length == 2 && this.values[0] == this.values[1]) {
            return new int[]{this.values[0]};
        }
        return this.values;
    }
}

