% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hri2.R
\name{hri2}
\alias{hri2}
\title{Resident-optimal matching in the hospital/residents problem with couples}
\usage{
hri2(nStudents = ncol(s.prefs), nColleges = ncol(c.prefs), nSlots = rep(1,
  nColleges), nCouples = ncol(co.prefs), s.prefs = NULL, c.prefs = NULL,
  co.prefs = NULL, seed = NULL, ...)
}
\arguments{
\item{nStudents}{integer indicating the number of students (in the college admissions problem) 
or men (in the stable marriage problem) in the market. Defaults to \code{ncol(s.prefs)}.}

\item{nColleges}{integer indicating the number of colleges (in the college admissions problem) 
or women (in the stable marriage problem) in the market. Defaults to \code{ncol(c.prefs)}.}

\item{nSlots}{vector of length \code{nColleges} indicating the number of places (i.e. 
quota) of each college. Defaults to \code{rep(1,nColleges)} for the marriage problem.}

\item{nCouples}{integer indicating the number of couples (in the college admissions problem) 
or men (in the stable marriage problem) in the market. Defaults to \code{ncol(co.prefs)}}

\item{s.prefs}{matrix of dimension \code{nColleges} \code{x} \code{nStudents} with the \code{j}th 
column containing student \code{j}'s ranking over colleges in decreasing order of 
preference (i.e. most preferred first).}

\item{c.prefs}{matrix of dimension \code{nStudents} \code{x} \code{nColleges} with the \code{i}th 
column containing college \code{i}'s ranking over students in decreasing order of 
preference (i.e. most preferred first).}

\item{co.prefs}{matrix of dimension \code{4} \code{x} \code{nCouplesPrefs} in long format with the \code{1}th and \code{2}th
columns containing student couple id's; \code{3}th and \code{4}th is a 2-tuple ranking over college preference for the couple (coupleStudent1.pref, coupleStudent2.pref) in decreasing order of 
preference by rows (i.e. most preferred first).}

\item{seed}{integer setting the state for random number generation.}

\item{...}{.}
}
\value{
\code{hri2} returns a list of the following elements:
\item{matchings}{list of matched students and colleges.}
\item{summary}{detailed report of the matching result, including futher information on ranks. See function: summary.hrci(x)}
}
\description{
Implements the Roth Peranson matching algorithm for the \href{https://en.wikipedia.org/wiki/National_Resident_Matching_Program}{hospital/residents problem with couples} as described in Roth and Peranson (1999). The function is based on a adoption of Fahiem Bacchus's \href{https://github.com/aperrau/stable-matching-suite}{stable-matching-suite}.
}
\section{Minimum required arguments}{

\code{hri2} requires the following combination of arguments, subject to the matching problem.
\describe{
\item{\code{nStudents, nColleges}}{Residence hospital problem without couples and random preferences}
\item{\code{nStudents, nColleges, nCouples, nSlots}}{Residence hospital problem with couples and random preferences.}
\item{\code{s.prefs, c.prefs, co.prefs, nSlots}}{Residence hospital problem with couples and given preferences.}
}
}

\examples{
## Example with given preferences
s.prefs <- matrix(c(4,2,3,5,1, 2,1,3,4,5, 1,2,3,4,5), 5,3)
c.prefs <- matrix(c(1,2,3, 1,2,3, 1,2,3, 1,2,3, 1,2,3), 3,5)
co.prefs <- matrix(c(4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5, 1,2,1,2,3,3,4,3, 1,1,2,2,2,3,3,4), 8,4)
res <- hri2(s.prefs=s.prefs, c.prefs=c.prefs, co.prefs=co.prefs, nSlots=c(1,1,1,1,1))
res$matchings
# summary(res)

## Example with random preferences
nStudents <- 50
nColleges <- 30
nCouples <- 4
nSlots <- sample(1:nStudents, nColleges)
res <- hri2(nStudents=nStudents, nColleges=nColleges, nCouples=nCouples, nSlots=nSlots)
res$matchings
# summary(res)
}
\references{
Gale, D. and L.S. Shapley (1962). College admissions and the stability 
of marriage. \emph{The American Mathematical Monthly}, 69(1):9--15.

Roth, A. E., & Peranson, E. (1999). The redesign of the matching market for American physicians: Some engineering aspects of economic design. \emph{American economic review}, 89(4), 748-780.

Kojima, F., Pathak, P. A., & Roth, A. E. (2013). Matching with couples: Stability and incentives in large markets. \emph{The Quarterly Journal of Economics}, 128(4), 1585-1632.
}
\author{
Sven Giegerich, Thilo Klein
}
\keyword{algorithms,}
\keyword{matching}
