/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.inputStructure;

import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.List;

public class Node {
    protected int idx;
    protected IntDomainVar successors;
    protected IntDomainVar inDegree;
    protected IntDomainVar timeWindow;
    protected IStateBitSet mandatorySuccessors;
    protected IStateBitSet condSuccessors;
    protected IStateBitSet incomparableNodes;

    public Node(Solver solver, int nbNodes, int idx, IntDomainVar successor, IntDomainVar inDegree, IntDomainVar timeWindow, List<BitSet[]> graphs) {
        this.idx = idx;
        this.successors = successor;
        this.inDegree = inDegree;
        this.timeWindow = timeWindow;
        this.mandatorySuccessors = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet prec = graphs.get(1)[idx];
        int i = prec.nextSetBit(0);
        while (i >= 0) {
            this.mandatorySuccessors.set(i, true);
            i = prec.nextSetBit(i + 1);
        }
        this.condSuccessors = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet condSucc = graphs.get(2)[idx];
        int i2 = condSucc.nextSetBit(0);
        while (i2 >= 0) {
            this.condSuccessors.set(i2, true);
            i2 = condSucc.nextSetBit(i2 + 1);
        }
        this.incomparableNodes = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet inc = graphs.get(3)[idx];
        int i3 = inc.nextSetBit(0);
        while (i3 >= 0) {
            this.incomparableNodes.set(i3, true);
            i3 = inc.nextSetBit(i3 + 1);
        }
    }

    public Node(Solver solver, int nbNodes, int idx, List<BitSet[]> graphs, List<int[][]> matrix) throws ContradictionException {
        this.idx = idx;
        this.successors = nbNodes == 2 ? solver.createBooleanVar("next_" + idx) : solver.createEnumIntVar("next_" + idx, 0, nbNodes - 1);
        for (int i = 0; i < nbNodes; ++i) {
            if (graphs.get(0)[idx].get(i)) continue;
            this.successors.remVal(i);
        }
        this.mandatorySuccessors = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet prec = graphs.get(1)[idx];
        int i = prec.nextSetBit(0);
        while (i >= 0) {
            this.mandatorySuccessors.set(i, true);
            i = prec.nextSetBit(i + 1);
        }
        this.condSuccessors = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet condSucc = graphs.get(2)[idx];
        int i2 = condSucc.nextSetBit(0);
        while (i2 >= 0) {
            this.condSuccessors.set(i2, true);
            i2 = condSucc.nextSetBit(i2 + 1);
        }
        this.incomparableNodes = solver.getEnvironment().makeBitSet(nbNodes);
        BitSet inc = graphs.get(3)[idx];
        int i3 = inc.nextSetBit(0);
        while (i3 >= 0) {
            this.incomparableNodes.set(i3, true);
            i3 = inc.nextSetBit(i3 + 1);
        }
        this.inDegree = solver.createBoundIntVar("deg_" + idx, matrix.get(0)[idx][0], matrix.get(0)[idx][1]);
        this.timeWindow = solver.createBoundIntVar("tw_" + idx, matrix.get(1)[idx][0], matrix.get(1)[idx][1]);
    }

    public int getIdx() {
        return this.idx;
    }

    public IntDomainVar getSuccessors() {
        return this.successors;
    }

    public IntDomainVar getInDegree() {
        return this.inDegree;
    }

    public IntDomainVar getTimeWindow() {
        return this.timeWindow;
    }

    public IStateBitSet getMandatorySuccessors() {
        return this.mandatorySuccessors;
    }

    public IStateBitSet getCondSuccessors() {
        return this.condSuccessors;
    }

    public IStateBitSet getIncomparableNodes() {
        return this.incomparableNodes;
    }
}

