% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mfx.R
\name{mfx}
\alias{mfx}
\title{Marginal effects for probit and matching models}
\usage{
mfx(m, toLatex = FALSE)
}
\arguments{
\item{m}{an object returned from function \code{stabit}.}

\item{toLatex}{logical: if \code{TRUE} the result tables are printed in Latex format. The default setting is \code{FALSE}.}
}
\description{
Marginal effects from regression coefficients for probit
and matching models.
}
\examples{
## 1. load results from Klein (2015a)
 data(klein15a)

## 2. apply mfx function and print results
 mfx(m=klein15a)
}
\author{
Thilo Klein
}
\references{
Klein, T. (2015a). \href{https://ideas.repec.org/p/cam/camdae/1521.html}{Does Anti-Diversification Pay? A One-Sided Matching Model of Microcredit}.
\emph{Cambridge Working Papers in Economics}, #1521.
}
\keyword{summary}

