% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanceMulti.R
\name{balanceMulti}
\alias{balanceMulti}
\title{Performs balance checking after multilevel matching.}
\usage{
balanceMulti(
  match.obj,
  student.cov = NULL,
  school.cov = NULL,
  include.tests = TRUE,
  single.table = FALSE
)
}
\arguments{
\item{match.obj}{A multilevel match object}

\item{student.cov}{Names of student level covariates that you want to check
balance}

\item{school.cov}{Names of school level covariates for which you want to
check balance, if any.}

\item{include.tests}{If TRUE include tests for balance.  FALSE just report
the means and differences.}

\item{single.table}{If FALSE include a list of student and school covariates
separately.  TRUE means single balance table.}
}
\value{
\item{students}{Balance table for student level covariates, as a
  dataframe.} \item{schools}{Balance table for school level covariates, as a
  dataframe.}
}
\description{
This function checks balance after multilevel balance. It checks balance on
both level-one (student) and level-two (school) covariates.
}
\details{
This function returns a list which include balance checks for before and
after matching for both level-one and level-two covariates. Balance
statistics include treated and control means, standardized differences, which
is the difference in means divided by the pooled standard deviation before
matching, and p-values for mean differences. It extracts the matched data and
calls `balanceTable` for student and school level covariates.
}
\examples{

	\dontrun{
# Load Catholic school data
data(catholic_schools)

student.cov <- c('minority','female','ses','mathach')

# Check balance student balance before matching
balanceTable(catholic_schools[c(student.cov,'sector')],  treatment = 'sector')

#Match schools but not students within schools
match.simple <- matchMulti(catholic_schools, treatment = 'sector',
school.id = 'school', match.students = FALSE)

#Check balance after matching - this checks both student and school balance
balanceMulti(match.simple, student.cov = student.cov)
}

}
\seealso{
See also \code{\link{matchMulti}}, \code{\link{matchMultisens}},
  \code{\link{matchMultioutcome}}, \code{\link{rematchSchools}}
}
\author{
Luke Keele, Penn State University, \email{ljk20@psu.edu} Sam
  Pimentel, University of Pennsylvania, \email{spi@wharton.upenn.edu}
}
\keyword{balance}
