% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radii.R
\name{set_radii_of_gyration}
\alias{set_radii_of_gyration}
\title{Set radii of gyration for a row in a data frame}
\usage{
set_radii_of_gyration(df, id, rg)
}
\arguments{
\item{df}{A data frame with an \code{id} column.}

\item{id}{The \code{id} value of the desired row.}

\item{rg}{A list with the following named elements:
\itemize{
\item \code{radii_gyration} Numeric 3x3 matrix radii of gyration.
}}
}
\value{
The updated data frame.
}
\description{
\code{set_radii_of_gyration()} sets radii of gyration for a
selected row in a data frame with an \code{id} column.
}
\examples{
rgl <- list(radii_gyration = c(x = 1, y = 2, z = 3))
set_radii_of_gyration(mp_table, "C.1", rgl)[1:5, ]
}
