% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{is.regular}
\alias{is.regular}
\title{Check if a DTMC is regular}
\usage{
is.regular(object)
}
\arguments{
\item{object}{a markovchain object}
}
\value{
A boolean value
}
\description{
Function to check wether a DTCM is regular
}
\details{
A Markov chain is regular if some of the powers of its matrix has all elements 
  strictly positive
}
\examples{
P <- matrix(c(0.5,  0.25, 0.25,
              0.5,     0, 0.5,
              0.25, 0.25, 0.5), nrow = 3)
colnames(P) <- rownames(P) <- c("R","N","S")
ciao <- as(P, "markovchain")
is.regular(ciao)

}
\references{
Matrix Analysis. Roger A.Horn, Charles R.Johnson. 2nd edition. 
  Corollary 8.5.8, Theorem 8.5.9
}
\seealso{
\code{\link{is.irreducible}}
}
\author{
Ignacio Cordón
}
