% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marked-package.R
\docType{data}
\name{dipper}
\alias{dipper}
\title{Dipper capture-recapture data}
\format{A data frame with 294 observations on the following 2 variables.
\describe{ \item{ch}{a character vector containing the encounter history of
each bird} \item{sex}{the sex of the bird: a factor with levels
\code{Female} \code{Male}} }}
\source{
Lebreton, J.-D., K. P. Burnham, J. Clobert, and D. R. Anderson.
1992. Modeling survival and testing biological hypotheses using marked
animals: case studies and recent advances. Ecol. Monogr. 62:67-118.
}
\description{
A capture-recapture data set on European dippers from France that
accompanies MARK as an example analysis using the CJS and POPAN models.  The
dipper data set was orginally described as an example by Lebreton et al
(1992).
}
\details{
This is a data set that accompanies program MARK as an example for CJS and
POPAN analyses.  The data can be stratified using sex as a grouping
variable.  The functions \code{run.dipper}, \code{run.dipper.alternate},
\code{run.dipper.popan} defined below in the examples mimic the models used
in the dbf file that accompanies MARK. Note that the models used in the MARK
example use PIM coding with the sin link function which is often better at
identifying the number of estimable parameters.  The approach used in the R
code uses design matrices and cannot use the sin link and is less capable at
counting parameters.  These differences are illustrated by comparing the
results of \code{run.dipper} and \code{run.dipper.alternate} which fit the
same set of "CJS" models.  The latter fits the models with constraints on
some parameters to achieve identifiability and the former does not. Although
it does not influence the selection of the best model it does infleunce
parameter counts and AIC ordering of some of the less competitive models. In
using design matrices it is best to constrain parameters that are confounded
(e.g., last occasion parameters in Phi(t)p(t) CJS model) when possible to
achieve more reliable counts of the number of estimable parameters.

Note that the covariate "sex" defined in dipper has values "Male" and
"Female".  It cannot be used directly in a formula for MARK without using it
do define groups because MARK.EXE will be unable to read in a covariate with
non-numeric values.  By using \code{groups="sex"} in the call the
\code{\link{process.data}} a factor "sex" field is created that can be used
in the formula.  Alternatively, a new covariate could be defined in the data
with say values 0 for Female and 1 for Male and this could be used without
defining groups because it is numeric.  This can be done easily by
translating the values of the coded variables to a numeric variable.  Factor
variables are numbered 1..k for k levels in alphabetic order.  Since Female
< Male in alphabetic order then it is level 1 and Male is level 2.  So the
following will create a numeric sex covariate.

\preformatted{ dipper$numeric.sex=as.numeric(dipper$sex)-1 }
}
\keyword{datasets}
