% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/todos.R
\name{todos}
\alias{todos}
\alias{fixmes}
\title{Get TODOs}
\usage{
todos(
  pattern = NULL,
  path = ".",
  force = getOption("mark.todos.force"),
  ext = getOption("mark.todos.ext"),
  ignore = NULL,
  ...
)

fixmes(
  pattern = NULL,
  path = ".",
  force = getOption("mark.todos.force"),
  ext = getOption("mark.todos.ext"),
  ignore = NULL,
  ...
)
}
\arguments{
\item{pattern}{A character string containing a regular expression to filter
for comments after tags; default \code{NULL} does not filter}

\item{path}{Where to search for the todos.  If this is a directory, paths
matching the \code{ext} will be included.  If a file, \code{ext} is ignored.}

\item{force}{If \code{TRUE} will force searching for files in directories that do
not contain an \code{.Rproj} file.  This can be controlled with the option
\code{mark.todos.force}}

\item{ext}{A vector of file extensions to search for todos.  Ignored when
\code{path} is not a directory or when \code{NULL}.}

\item{ignore}{A regular expression for files to ignore.  Ignored if \code{path} is
not a directory or when \code{NULL}.}

\item{...}{Additional parameters passed to \code{grep} (Except for \code{pattern}, \code{x},
and \code{value})}
}
\value{
\code{NULL} if none are found, otherwise a \code{data.frame} with the line
number, file name, and TODO comment.
}
\description{
Search for \verb{#`` TODO} tags
}
\details{
Searches for \code{TODO} comments in files.  Extensions with \code{md}, \code{Rmd},
and \code{qmd} specifically search for a \verb{<-- TODO * -->} string, whereas
everything else is found with \verb{# TODO}.
}
\examples{
\dontrun{
file <- tempfile()
writeLines(c(
  "# TODO make x longer",
  "x <- 1:10",
  "length(x)",
  "# TODO add another example",
  "# FIXME This is a fixme"
  ), file)
todos(path = file)
todos("example", path = file)
fixmes(path = file)
file.remove(file)
}
}
