% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heips.R
\name{heips}
\alias{heips}
\title{Calculates Heip's Evenness Index}
\usage{
heips(X, groups, species.table = NULL, metric = "ABUNDANCE", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
  column \code{Heips_group} for each entry in \code{groups}.

  If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
  value is assigned NA.
}
\description{
This function calculates Heip's Evenness Index (HE) of the
  community for \eqn{j} areas and \eqn{i} years.
}
\details{
Heip's Evenness Index (HE): \deqn{HE = (exp^{H'} - 1)/(S - 1)} where
  \eqn{H'} is Shannon's index of diversity and \eqn{S} is species richness.
  This index ranges from 0 to 1 and measures how equally the species richness
  contributes to the total abundance or biomass of the community (Heip,
  1974).
}
\examples{
data(X)
heips(X, groups = "ALL", species.table = NULL, metric = "ABUNDANCE", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
  selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
  Aquat. Sci. 3232: xii + 212 p.

  Heip C. 1974. A new index measuring evenness. J. Mar. Biol. Asso. UK 54:
  555-557.

  Kenchington T, Kenchington E (2013) Biodiversity Metrics for Use in the
  Ecosystem Approach to Oceans Management. Can. Tech. Rep. Fish. Aquat. Sci.
  3059: vi+188p.
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{hillN1}}, \code{\link{hillN2}},
  \code{\link{kemptonQ}}, \code{\link{margalef}},
  \code{\link{pielouEvenness}}, \code{\link{shannon}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
  Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
