% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{portfolio}
\alias{portfolio}
\alias{write_portfolio}
\alias{read_portfolio}
\title{Writing a portfolio to disk}
\usage{
write_portfolio(x, dsn, overwrite = FALSE, ...)

read_portfolio(src, ...)
}
\arguments{
\item{x}{A portfolio object processed with \code{mapme.biodiversity}}

\item{dsn}{A file path for the output file. Should end with \code{'.gpkg'}}

\item{overwrite}{A logical indicating if the output file should be overwritten
if it exists}

\item{...}{Additional arguments supplied to \code{st_read()}}

\item{src}{A character vector pointing to a GeoPackage that has been
previously written to disk via \code{write_portfolio()}}
}
\value{
\code{write_portfolio()} returns \code{x}, invisibly.

\code{read_portfolio()} reutnrs an \code{sf} object object with nested list
columns for every indicator table found in the GeoPackage source file.
}
\description{
\code{write_portfolio()} writes a processed biodiversity portfolio to disk.
In order to ensure interoperability with other geospatial software the only
supported format is the GeoPackage.
The metadata of a portfolio together with the geometry will be written
to a table called \code{'metadata'}. All calculated indicators, which
are expected to be present as nested list columns, will be written to their
own respective tables. In order to allow re-joining the metadata with the
indicators, it is expected that a column called \code{'assetid'} which uniquely
identifies all assets is present. Usually, users do not have to take care of
this since the usual \code{mapme.biodiversity} workflow will ensure that this
columns is present. Additional arguments to \code{st_write()} can be supplied.

\code{read_portfolio()} is used to read a portfolio object that was previously
written to disk via \code{write_portfolio()} back into R as an \code{sf} object.
It should be directed against a GeoPackage which was the output
of \code{write_portfolio()}, otherwise the function is very likely to fail.
All available indicators will be read back into R as nested list columns
reflecting the output once \code{calc_indicators()} has been called.
}
