% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{legend_element}
\alias{legend_element}
\title{Legend Element}
\usage{
legend_element(
  variables,
  colours,
  colour_type = c("fill", "stroke"),
  variable_type = c("category", "gradient"),
  title = "",
  css = ""
)
}
\arguments{
\item{variables}{variables assigned to colours}

\item{colours}{vector of hex colours assigned to variables}

\item{colour_type}{one of "fill" or "stroke"}

\item{variable_type}{one of category (discrete) or gradient (continuous)}

\item{title}{string used as the legend title}

\item{css}{string of css to control appearance.}
}
\description{
Creates a mapdeck legend element for when you want to manually specify a legend (using \link{mapdeck_legend})
}
\examples{

l1 <- legend_element(
	variables = c("a","b")
	, colours = c("#00FF00","#FF0000")
	, colour_type = "fill"
	, variable_type = "category"
	, title = "my title"
)

}
\seealso{
\link{mapdeck_legend}
}
