% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_grid.R
\name{add_grid}
\alias{add_grid}
\title{Add Grid}
\usage{
add_grid(map, data = get_map_data(map), lon = NULL, lat = NULL,
  polyline = NULL, colour_range = viridisLite::viridis(5),
  cell_size = 1000, extruded = TRUE, elevation_scale = 1, layer_id,
  digits = 6)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{column of \code{data} containing the polylines}

\item{colour_range}{vector of hex colours}

\item{cell_size}{size of each cell in meters}

\item{extruded}{logical indicating if cells are elevated or not}

\item{elevation_scale}{cell elevation multiplier}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}
}
\description{
The Grid Layer renders a grid heatmap based on an array of points.
It takes the constant size all each cell, projects points into cells.
The color and height of the cell is scaled by number of points it contains.
}
\examples{
\donttest{
## You need a valid access token from Mapbox
key <- 'abc'

df <- read.csv(paste0(
'https://raw.githubusercontent.com/uber-common/deck.gl-data/master/',
'examples/3d-heatmap/heatmap-data.csv'
))


mapdeck( token = key, style = 'mapbox://styles/mapbox/dark-v9', pitch = 45 ) \%>\%
add_grid(
  data = df
  , lat = "lat"
  , lon = "lng"
  , cell_size = 5000
  , elevation_scale = 50
  , layer_id = "grid_layer"
)
}

}
