% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_grid_EEA.R
\name{esp_get_grid_EEA}
\alias{esp_get_grid_EEA}
\title{Get \code{\link[sf:sf]{sf}} \code{POLYGON} of the national geographic grids from EEA}
\source{
\href{https://www.eea.europa.eu/en/datahub/datahubitem-view/3c362237-daa4-45e2-8c16-aaadfb1a003b}{EEA reference grid}.
}
\usage{
esp_get_grid_EEA(
  resolution = 100,
  type = "main",
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid in kms. Could be \code{1}, \code{10} or \code{100}.}

\item{type}{The scope of the grid. It could be mainland Spain (\code{"main"}) or
the Canary Islands (\code{"canary"}).}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{\link[sf:sf]{sf}} \code{POLYGON}.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{POLYGON} with the geographic grids of Spain as
provided by the European Environment Agency (EEA).
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{

grid <- esp_get_grid_EEA(type = "main", resolution = 100)
grid_can <- esp_get_grid_EEA(type = "canary", resolution = 100)
esp <- esp_get_country(moveCAN = FALSE)

library(ggplot2)

ggplot(grid) +
  geom_sf() +
  geom_sf(data = grid_can) +
  geom_sf(data = esp, fill = NA) +
  theme_light() +
  labs(title = "EEA Grid for Spain")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other grids: 
\code{\link{esp_get_grid_BDN}()},
\code{\link{esp_get_grid_ESDAC}()},
\code{\link{esp_get_grid_MTN}()}
}
\concept{grids}
