% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_hydrobasin.R
\name{esp_get_hydrobasin}
\alias{esp_get_hydrobasin}
\title{Get the drainage basin demarcations of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_hydrobasin(
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  domain = "land"
)
}
\arguments{
\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with \code{options(mapSpain_cache_dir = "path/to/dir")}.
See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the polygon. Values available are "3", "6.5"
or "10".}

\item{domain}{Possible values are "land", that includes only
the ground part or the ground or "landsea", that includes both the ground
and the related sea waters of the basin}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a simple feature (\code{sf}) object containing areas with the required
hydrograpic elements of Spain.
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.
}
\examples{
\donttest{
# This code would produce a nice plot - It will take a few seconds to run
library(sf)
all <- esp_get_prov()
mainland <-
  all[all$codauto != esp_dict_region_code("Canarias", destination = "codauto"), ]
hydroland <- esp_get_hydrobasin(domain = "land")
hydrolandsea <- esp_get_hydrobasin(domain = "landsea")

# Plot
opar <- par(no.readonly = TRUE)

par(mar = c(0, 0, 0, 0))

# Background
plot(st_as_sfc(st_bbox(mainland)), col = "grey90", border = NA)

plot(
  st_geometry(hydrolandsea),
  col = "skyblue3",
  border = NA,
  add = TRUE
)
plot(
  st_geometry(mainland),
  col = "grey70",
  border = "grey50",
  add = TRUE
)
plot(
  st_geometry(hydroland),
  col = adjustcolor("skyblue", alpha.f = 0.5),
  add = TRUE,
  border = "lightblue"
)

par(opar)
}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{natural}
