% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_prov.R
\name{esp_get_prov}
\alias{esp_get_prov}
\title{Get Provinces boundaries of Spain}
\usage{
esp_get_prov(prov = NULL, ...)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See Details.}

\item{...}{Additional parameters from \link{esp_get_nuts}.}
}
\value{
A \code{POLYGON/POINT} object.
}
\description{
Loads a simple feature (\code{sf}) object containing the
province boundaries of Spain.
}
\details{
When using \code{prov} you can use and mix names and NUTS codes
(levels 1, 2 or 3), ISO codes (corresponding to level 2 or 3) or
\code{cpro}.

Ceuta and Melilla are considered as provinces on this dataset.

When calling a superior level (Autonomous Community or NUTS1) , all the
 provinces of that level would be added.
}
\examples{

library(sf)

# Random Provinces

Random <-
  esp_get_prov(prov = c("Zamora",
                        "Palencia",
                        "ES-GR",
                        "ES521",
                        "01"))
plot(st_geometry(Random), col = hcl.colors(6))

# All Provinces of a Zone plus an addition

Mix <-
  esp_get_prov(prov = c("Noroeste",
                        "Castilla y Leon", "La Rioja"),
               resolution = "20")
plot(
  Mix[, "nuts1.code"],
  pal = hcl.colors(3),
  key.pos = NULL,
  main = NULL,
  border = "white"
)
}
\seealso{
\link{esp_get_hex_prov}, \link{esp_get_nuts}, \link{esp_get_ccaa},
\link{esp_get_munic}, \link{esp_codelist}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
