% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_generate.R
\name{generate}
\alias{generate}
\alias{generate_random}
\alias{generate_smallworld}
\alias{generate_scalefree}
\alias{generate_permutation}
\alias{generate_utilities}
\title{Make networks with a stochastic element}
\usage{
generate_random(n, p = 0.5, directed = FALSE, with_attr = TRUE)

generate_smallworld(n, p = 0.05, directed = FALSE, width = 2)

generate_scalefree(n, p = 1, directed = FALSE)

generate_permutation(.data, with_attr = TRUE)

generate_utilities(n, steps = 1, volatility = 0, threshold = 0)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Power of the preferential attachment, default is 1.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{with_attr}{Logical whether any attributes of the object
should be retained.
By default TRUE.}

\item{width}{Integer specifying the width of the ring,
breadth of the branches, or maximum extent of the neighbourbood.}

\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{steps}{Number of simulation steps to run.
By default 1: a single, one-shot simulation.
If more than 1, further iterations will update the utilities
depending on the values of the volatility and threshold parameters.}

\item{volatility}{How much change there is between steps.
Only if volatility is more than 1 do further simulation steps make sense.
This is passed on to \code{stats::rnorm} as the \code{sd} or standard deviation
parameter.}

\item{threshold}{This parameter can be used to mute or disregard stepwise
changes in utility that are minor.
The default 0 will recognise all changes in utility,
but raising the threshold will mute any changes less than this threshold.}
}
\value{
By default an \code{igraph} object is returned,
but this can be coerced into other types of objects
using \code{as_matrix()}, \code{as_tidygraph()}, or \code{as_network()}.
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some element of randomisation.
They are particularly useful for creating a distribution of networks
for exploring or testing network properties.
Note that passing the first argument an empirical network
will prompt these functions to generate a network with the same dimensions.
}
\section{Functions}{
\itemize{
\item \code{generate_random()}: Generates a random network with a particular probability.

\item \code{generate_smallworld()}: Generates a small-world structure
following the lattice rewiring model.

\item \code{generate_scalefree()}: Generates a scale-free structure
following the preferential attachment model.

\item \code{generate_permutation()}: Generates a permutation of the original network
using a Fisher-Yates shuffle on both the rows and columns (for a one-mode network)
or on each of the rows and columns (for a two-mode network).

\item \code{generate_utilities()}: Generates a utility matrix

}}
\examples{
autographr(generate_random(12, 0.4))
# autographr(generate_random(c(6, 6), 0.4))
autographr(generate_smallworld(12, 0.025))
autographr(generate_smallworld(12, 0.25))
autographr(generate_scalefree(12, 0.25))
autographr(generate_scalefree(12, 1.25))
autographr(ison_adolescents)
autographr(generate_permutation(ison_adolescents))
}
\references{
Erdős, Paul, and Alfréd Rényi. (1959).
"\href{https://www.renyi.hu/~p_erdos/1959-11.pdf}{On Random Graphs I}"
\emph{Publicationes Mathematicae}. 6: 290–297.

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.

Barabási, Albert-László, and Réka Albert. 1999.
“Emergence of Scaling in Random Networks.”
\emph{Science} 286(5439):509–12.
\doi{10.1126/science.286.5439.509}.
}
\seealso{
Other makes: 
\code{\link{as}()},
\code{\link{create}},
\code{\link{read}}
}
\concept{makes}
