% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_missing}
\alias{compare_missing}
\title{Compare missing observations for 'many' data}
\usage{
compare_missing(datacube, dataset = "all", variable = "all")
}
\arguments{
\item{datacube}{A datacube from one of the many packages.}

\item{dataset}{A dataset in a datacube from one of the many packages.
NULL by default.
That is, all datasets in the datacube are used.
To select two or more datasets, please declare them as a vector.}

\item{variable}{Would you like to focus on one, or more, specific variables
present in one or more datasets in the 'many' datacube?
By default "all".
For multiple variables, please declare variable names as a vector.}
}
\value{
\code{compare_missing()} returns a tibble with information about each dataset
including the number of observations, the number of variables,
the earliest date, and the latest date in all observations.
}
\description{
Compare missing observations for 'many' data
}
\details{
\code{compare_missing()} compares the missing observations for variables
in each dataset in a 'many' datacube.
}
\examples{
\donttest{
compare_missing(emperors)
plot(compare_missing(emperors))
}
}
\seealso{
Other compare_: 
\code{\link{compare_categories}()},
\code{\link{compare_dimensions}()},
\code{\link{compare_overlap}()}
}
\concept{compare_}
